/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.output;

import java.io.IOException;
import java.io.OutputStream;
import uk.org.okapibarcode.backend.OkapiInternalException;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.graphics.Circle;
import uk.org.okapibarcode.graphics.Color;
import uk.org.okapibarcode.graphics.Hexagon;
import uk.org.okapibarcode.graphics.Rectangle;
import uk.org.okapibarcode.graphics.TextAlignment;
import uk.org.okapibarcode.graphics.TextBox;
import uk.org.okapibarcode.output.ExtendedOutputStreamWriter;
import uk.org.okapibarcode.output.SymbolRenderer;
import uk.org.okapibarcode.util.Doubles;
import uk.org.okapibarcode.util.Integers;

public class PostScriptRenderer
implements SymbolRenderer {
    private final OutputStream out;
    private final double magnification;
    private final Color paper;
    private final Color ink;
    private final int rotation;

    public PostScriptRenderer(OutputStream out, double magnification, Color paper, Color ink) {
        this(out, magnification, paper, ink, 0);
    }

    public PostScriptRenderer(OutputStream out, double magnification, Color paper, Color ink, int rotation) {
        this.out = out;
        this.magnification = magnification;
        this.paper = paper;
        this.ink = ink;
        this.rotation = Integers.normalizeRotation(rotation);
    }

    @Override
    public void render(Symbol symbol) throws IOException {
        String content = symbol.getContent();
        int width = (int)Math.ceil((double)symbol.getWidth() * this.magnification);
        int height = (int)Math.ceil((double)symbol.getHeight() * this.magnification);
        int marginX = (int)((double)symbol.getQuietZoneHorizontal() * this.magnification);
        int marginY = (int)((double)symbol.getQuietZoneVertical() * this.magnification);
        int rotatedHeight = height;
        int rotatedWidth = width;
        switch (this.rotation) {
            case 90: 
            case 270: {
                rotatedHeight = width;
                rotatedWidth = height;
                break;
            }
        }
        String title = content.isEmpty() ? "OkapiBarcode Generated Symbol" : content;
        try (ExtendedOutputStreamWriter writer = new ExtendedOutputStreamWriter(this.out, "%.2f");){
            int i;
            writer.append("%!PS-Adobe-3.0 EPSF-3.0\n");
            writer.append("%%Creator: OkapiBarcode\n");
            writer.append("%%Title: ").append(title).append('\n');
            writer.append("%%Pages: 0\n");
            writer.append("%%BoundingBox: 0 0 ").appendInt(rotatedWidth).append(" ").appendInt(rotatedHeight).append("\n");
            writer.append("%%EndComments\n");
            writer.append("/TL { setlinewidth moveto lineto stroke } bind def\n");
            writer.append("/TC { moveto 0 360 arc 360 0 arcn fill } bind def\n");
            writer.append("/TH { 0 setlinewidth moveto lineto lineto lineto lineto lineto closepath fill } bind def\n");
            writer.append("/TB { 2 copy } bind def\n");
            writer.append("/TR { newpath 4 1 roll exch moveto 1 index 0 rlineto 0 exch rlineto neg 0 rlineto closepath fill } bind def\n");
            writer.append("/TE { pop pop } bind def\n");
            switch (this.rotation) {
                case 90: {
                    writer.append("gsave\n").append(-this.rotation).append(" rotate\n").append(-width).append(" 0.00 translate\n");
                    break;
                }
                case 180: {
                    writer.append("gsave\n").append(-this.rotation).append(" rotate\n").append(-width).append(" ").append(-height).append(" translate\n");
                    break;
                }
                case 270: {
                    writer.append("gsave\n").append(-this.rotation).append(" rotate\n").append("0.00 ").append(-height).append(" translate\n");
                    break;
                }
            }
            writer.append("newpath\n");
            writer.append((double)this.ink.red / 255.0).append(" ").append((double)this.ink.green / 255.0).append(" ").append((double)this.ink.blue / 255.0).append(" setrgbcolor\n");
            writer.append((double)this.paper.red / 255.0).append(" ").append((double)this.paper.green / 255.0).append(" ").append((double)this.paper.blue / 255.0).append(" setrgbcolor\n");
            writer.append(height).append(" 0.00 TB 0.00 ").append(width).append(" TR\n");
            for (i = 0; i < symbol.getRectangles().size(); ++i) {
                Rectangle rect = symbol.getRectangles().get(i);
                if (i == 0) {
                    writer.append("TE\n");
                    writer.append((double)this.ink.red / 255.0).append(" ").append((double)this.ink.green / 255.0).append(" ").append((double)this.ink.blue / 255.0).append(" setrgbcolor\n");
                    writer.append(rect.height * this.magnification).append(" ").append((double)height - (rect.y + rect.height) * this.magnification - (double)marginY).append(" TB ").append(rect.x * this.magnification + (double)marginX).append(" ").append(rect.width * this.magnification).append(" TR\n");
                    continue;
                }
                Rectangle prev = symbol.getRectangles().get(i - 1);
                if (!Doubles.roughlyEqual(rect.height, prev.height) || !Doubles.roughlyEqual(rect.y, prev.y)) {
                    writer.append("TE\n");
                    writer.append((double)this.ink.red / 255.0).append(" ").append((double)this.ink.green / 255.0).append(" ").append((double)this.ink.blue / 255.0).append(" setrgbcolor\n");
                    writer.append(rect.height * this.magnification).append(" ").append((double)height - (rect.y + rect.height) * this.magnification - (double)marginY).append(" ");
                }
                writer.append("TB ").append(rect.x * this.magnification + (double)marginX).append(" ").append(rect.width * this.magnification).append(" TR\n");
            }
            for (i = 0; i < symbol.getTexts().size(); ++i) {
                TextAlignment alignment;
                TextBox text = symbol.getTexts().get(i);
                TextAlignment textAlignment = alignment = text.alignment == TextAlignment.JUSTIFY && text.text.length() == 1 ? TextAlignment.CENTER : text.alignment;
                if (i == 0) {
                    writer.append("TE\n");
                    writer.append((double)this.ink.red / 255.0).append(" ").append((double)this.ink.green / 255.0).append(" ").append((double)this.ink.blue / 255.0).append(" setrgbcolor\n");
                }
                writer.append("matrix currentmatrix\n");
                writer.append("/").append(symbol.getFontName()).append(" findfont\n");
                writer.append((double)symbol.getFontSize() * this.magnification).append(" scalefont setfont\n");
                double y = (double)height - text.y * this.magnification - (double)marginY;
                switch (alignment) {
                    case LEFT: {
                        double leftX = this.magnification * text.x + (double)marginX;
                        writer.append(" 0 0 moveto ").append(leftX).append(" ").append(y).append(" translate 0.00 rotate 0 0 moveto\n");
                        writer.append(" (").append(text.text).append(") show\n");
                        break;
                    }
                    case JUSTIFY: {
                        double textX = this.magnification * text.x + (double)marginX;
                        double textW = this.magnification * text.width;
                        writer.append(" 0 0 moveto ").append(textX).append(" ").append(y).append(" translate 0.00 rotate 0 0 moveto\n");
                        writer.append(" (").append(text.text).append(") dup stringwidth pop ").append(textW).append(" sub neg 1 index length 1 sub div 0").append(" 3 -1 roll ashow\n");
                        break;
                    }
                    case RIGHT: {
                        double rightX = this.magnification * text.x + this.magnification * text.width + (double)marginX;
                        writer.append(" 0 0 moveto ").append(rightX).append(" ").append(y).append(" translate 0.00 rotate 0 0 moveto\n");
                        writer.append(" (").append(text.text).append(") stringwidth\n");
                        writer.append("pop\n");
                        writer.append("-1 mul 0 rmoveto\n");
                        writer.append(" (").append(text.text).append(") show\n");
                        break;
                    }
                    case CENTER: {
                        double centerX = this.magnification * text.x + this.magnification * text.width / 2.0 + (double)marginX;
                        writer.append(" 0 0 moveto ").append(centerX).append(" ").append(y).append(" translate 0.00 rotate 0 0 moveto\n");
                        writer.append(" (").append(text.text).append(") stringwidth\n");
                        writer.append("pop\n");
                        writer.append("-2 div 0 rmoveto\n");
                        writer.append(" (").append(text.text).append(") show\n");
                        break;
                    }
                    default: {
                        throw new OkapiInternalException("Unknown alignment: " + (Object)((Object)alignment));
                    }
                }
                writer.append("setmatrix\n");
            }
            for (i = 0; i < symbol.getTarget().size(); i += 2) {
                Circle circle1 = symbol.getTarget().get(i);
                Circle circle2 = symbol.getTarget().get(i + 1);
                if (i == 0) {
                    writer.append("TE\n");
                    writer.append((double)this.ink.red / 255.0).append(" ").append((double)this.ink.green / 255.0).append(" ").append((double)this.ink.blue / 255.0).append(" setrgbcolor\n");
                    writer.append((double)this.ink.red / 255.0).append(" ").append((double)this.ink.green / 255.0).append(" ").append((double)this.ink.blue / 255.0).append(" setrgbcolor\n");
                }
                double x1 = circle1.centreX;
                double x2 = circle2.centreX;
                double y1 = (double)height - circle1.centreY;
                double y2 = (double)height - circle2.centreY;
                double r1 = circle1.radius;
                double r2 = circle2.radius;
                writer.append(x1 + (double)marginX).append(" ").append(y1 - (double)marginY).append(" ").append(r1).append(" ").append(x2 + (double)marginX).append(" ").append(y2 - (double)marginY).append(" ").append(r2).append(" ").append(x2 + r2 + (double)marginX).append(" ").append(y2 - (double)marginY).append(" TC\n");
            }
            for (Hexagon hexagon : symbol.getHexagons()) {
                for (int j = 0; j < 6; ++j) {
                    writer.append(hexagon.getX(j) + (double)marginX).append(" ").append((double)height - hexagon.getY(j) - (double)marginY).append(" ");
                }
                writer.append(" TH\n");
            }
            if (this.rotation != 0) {
                writer.append("grestore\n");
            }
            writer.append("\nshowpage\n");
        }
    }
}

