/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.graphics;

import java.util.Objects;

public final class Hexagon {
    private static final double INK_SPREAD = 1.25;
    private static final double[] OFFSET_X = new double[]{0.0, 0.86, 0.86, 0.0, -0.86, -0.86};
    private static final double[] OFFSET_Y = new double[]{1.0, 0.5, -0.5, -1.0, -0.5, 0.5};
    public final double centreX;
    public final double centreY;
    public final int factor;

    public Hexagon(double centreX, double centreY, int factor) {
        this.centreX = centreX;
        this.centreY = centreY;
        this.factor = factor;
    }

    public double getX(int vertex) {
        if (vertex < 0 || vertex > 5) {
            throw new IllegalArgumentException("Vertex must be between 0 and 5");
        }
        return this.centreX + OFFSET_X[vertex] * 1.25 * (double)this.factor;
    }

    public double getY(int vertex) {
        if (vertex < 0 || vertex > 5) {
            throw new IllegalArgumentException("Vertex must be between 0 and 5");
        }
        return this.centreY + OFFSET_Y[vertex] * 1.25 * (double)this.factor;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Hexagon)) {
            return false;
        }
        Hexagon h = (Hexagon)other;
        return this.centreX == h.centreX && this.centreY == h.centreY && this.factor == h.factor;
    }

    public int hashCode() {
        return Objects.hash(this.centreX, this.centreY, this.factor);
    }

    public String toString() {
        return "Hexagon[centreX=" + this.centreX + ", centreY=" + this.centreY + ", factor=" + this.factor + "]";
    }
}

