/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.QrCode;

public class UpnQr
extends QrCode {
    public UpnQr() {
        this.eciMode = 4;
        this.preferredVersion = 15;
        this.preferredEccLevel = QrCode.EccLevel.M;
        this.improveEccLevelIfPossible = false;
        this.forceByteCompaction = true;
    }

    @Override
    public void setEciMode(int eciMode) {
        if (eciMode != 4) {
            throw new OkapiInputException("UPN QR requires ECI mode 4");
        }
        super.setEciMode(eciMode);
    }

    @Override
    public void setPreferredVersion(int version) {
        if (version != 15) {
            throw new OkapiInputException("UPN QR requires version 15");
        }
        super.setPreferredVersion(version);
    }

    @Override
    public void setPreferredEccLevel(QrCode.EccLevel preferredEccLevel) {
        if (preferredEccLevel != QrCode.EccLevel.M) {
            throw new OkapiInputException("UPN QR requires ECC level M");
        }
        super.setPreferredEccLevel(preferredEccLevel);
    }

    @Override
    public void setForceByteCompaction(boolean forceByteCompaction) {
        if (!forceByteCompaction) {
            throw new OkapiInputException("UPN QR requires forced byte compaction");
        }
        super.setForceByteCompaction(forceByteCompaction);
    }

    @Override
    public boolean supportsGs1() {
        return false;
    }
}

