/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import uk.org.okapibarcode.backend.HumanReadableLocation;
import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.graphics.Rectangle;
import uk.org.okapibarcode.graphics.TextBox;

public class Postnet
extends Symbol {
    private static final String[] PN_TABLE = new String[]{"LLSSS", "SSSLL", "SSLSL", "SSLLS", "SLSSL", "SLSLS", "SLLSS", "LSSSL", "LSSLS", "LSLSS"};
    private static final String[] PL_TABLE = new String[]{"SSLLL", "LLLSS", "LLSLS", "LLSSL", "LSLLS", "LSLSL", "LSSLL", "SLLLS", "SLLSL", "SLSLL"};
    private Mode mode;
    private double moduleWidthRatio;

    public Postnet() {
        this(Mode.POSTNET);
    }

    public Postnet(Mode mode) {
        this.mode = mode;
        this.moduleWidthRatio = 1.5;
        this.default_height = 12;
        this.humanReadableLocation = HumanReadableLocation.NONE;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setModuleWidthRatio(double moduleWidthRatio) {
        this.moduleWidthRatio = moduleWidthRatio;
    }

    public double getModuleWidthRatio() {
        return this.moduleWidthRatio;
    }

    @Override
    protected void encode() {
        String[] table = this.mode == Mode.POSTNET ? PN_TABLE : PL_TABLE;
        this.encode(table);
    }

    private void encode(String[] table) {
        if (this.content.length() > 38) {
            throw OkapiInputException.inputTooLong();
        }
        if (!this.content.matches("[0-9]*")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        int sum = 0;
        int destLen = 7 + this.content.length() * 5;
        StringBuilder dest = new StringBuilder(destLen);
        dest.append('L');
        for (int i = 0; i < this.content.length(); ++i) {
            dest.append(table[this.content.charAt(i) - 48]);
            sum += this.content.charAt(i) - 48;
        }
        int checkDigit = (10 - sum % 10) % 10;
        this.infoLine("Check Digit: " + checkDigit);
        dest.append(table[checkDigit]);
        dest.append('L');
        assert (dest.length() == destLen);
        this.infoLine("Encoding: " + dest);
        this.readable = this.content;
        this.pattern = new String[]{dest.toString()};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    @Override
    protected void plotSymbol() {
        this.resetPlotElements();
        int baseY = this.humanReadableLocation == HumanReadableLocation.TOP ? this.getTheoreticalHumanReadableHeight() : 0;
        double x = 0.0;
        double w = this.moduleWidth;
        double dx = (1.0 + this.moduleWidthRatio) * w;
        int shortHeight = (int)(0.4 * (double)this.default_height);
        for (int xBlock = 0; xBlock < this.pattern[0].length(); ++xBlock) {
            double h;
            double y;
            if (this.pattern[0].charAt(xBlock) == 'L') {
                y = baseY;
                h = this.default_height;
            } else {
                y = baseY + this.default_height - shortHeight;
                h = shortHeight;
            }
            this.rectangles.add(new Rectangle(x, y, w, h));
            x += dx;
        }
        this.symbol_width = (int)Math.ceil((double)(this.pattern[0].length() - 1) * dx + w);
        this.symbol_height = this.default_height;
        if (this.humanReadableLocation != HumanReadableLocation.NONE && !this.readable.isEmpty()) {
            double baseline = this.humanReadableLocation == HumanReadableLocation.TOP ? (double)this.fontSize : (double)(this.symbol_height + this.fontSize);
            this.texts.add(new TextBox(0.0, baseline, this.symbol_width, this.readable, this.humanReadableAlignment));
        }
    }

    public static enum Mode {
        PLANET,
        POSTNET;

    }
}

