/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import uk.org.okapibarcode.backend.Code128;
import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.Symbol;

public class Nve18
extends Symbol {
    @Override
    protected void encode() {
        if (this.content.length() > 17) {
            throw OkapiInputException.inputTooLong();
        }
        if (!this.content.matches("[0-9]+")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        StringBuilder gs1 = new StringBuilder();
        int zeros = 17 - this.content.length();
        for (int i = 0; i < zeros; ++i) {
            gs1.append('0');
        }
        gs1.append(this.content);
        int p = 0;
        int count = 0;
        for (int i = gs1.length() - 1; i >= 0; --i) {
            int c = Character.getNumericValue(gs1.charAt(i));
            if (p % 2 == 0) {
                c *= 3;
            }
            count += c;
            ++p;
        }
        int check = 10 - count % 10;
        if (check == 10) {
            check = 0;
        }
        this.infoLine("NVE Check Digit: " + check);
        this.content = "[00]" + gs1 + check;
        Code128 code128 = new Code128();
        code128.setDataType(Symbol.DataType.GS1);
        code128.setHumanReadableLocation(this.humanReadableLocation);
        code128.setContent(this.content);
        this.readable = code128.readable;
        this.pattern = code128.pattern;
        this.row_count = code128.row_count;
        this.row_height = code128.row_height;
        this.info(code128.encodeInfo);
    }
}

