/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.util.Locale;
import uk.org.okapibarcode.backend.HumanReadableLocation;
import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.OkapiInternalException;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.graphics.Rectangle;
import uk.org.okapibarcode.util.Arrays;

public class KixCode
extends Symbol {
    private static final String[] ROYAL_TABLE = new String[]{"TTFF", "TDAF", "TDFA", "DTAF", "DTFA", "DDAA", "TADF", "TFTF", "TFDA", "DATF", "DADA", "DFTA", "TAFD", "TFAD", "TFFT", "DAAD", "DAFT", "DFAT", "ATDF", "ADTF", "ADDA", "FTTF", "FTDA", "FDTA", "ATFD", "ADAD", "ADFT", "FTAD", "FTFT", "FDAT", "AADD", "AFTD", "AFDT", "FATD", "FADT", "FFTT"};
    private static final char[] KR_SET = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public KixCode() {
        this.humanReadableLocation = HumanReadableLocation.NONE;
    }

    @Override
    protected void encode() {
        this.content = this.content.toUpperCase(Locale.ENGLISH);
        if (!this.content.matches("[0-9A-Z]+")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        StringBuilder sb = new StringBuilder(this.content.length());
        for (int i = 0; i < this.content.length(); ++i) {
            int j = Arrays.positionOf(this.content.charAt(i), KR_SET);
            sb.append(ROYAL_TABLE[j]);
        }
        String dest = sb.toString();
        this.infoLine("Encoding: " + dest);
        this.readable = "";
        this.pattern = new String[]{dest};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    @Override
    protected void plotSymbol() {
        this.resetPlotElements();
        int x = 0;
        boolean w = true;
        int y = 0;
        int h = 0;
        for (int xBlock = 0; xBlock < this.pattern[0].length(); ++xBlock) {
            char c = this.pattern[0].charAt(xBlock);
            switch (c) {
                case 'A': {
                    y = 0;
                    h = 5;
                    break;
                }
                case 'D': {
                    y = 3;
                    h = 5;
                    break;
                }
                case 'F': {
                    y = 0;
                    h = 8;
                    break;
                }
                case 'T': {
                    y = 3;
                    h = 2;
                    break;
                }
                default: {
                    throw new OkapiInternalException("Unknown pattern character: " + c);
                }
            }
            this.rectangles.add(new Rectangle(x, y, (double)w, h));
            x += 2;
        }
        this.symbol_width = (this.pattern[0].length() - 1) * 2 + 1;
        this.symbol_height = 8;
    }
}

