/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.util.Locale;
import uk.org.okapibarcode.backend.HumanReadableLocation;
import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.graphics.Rectangle;
import uk.org.okapibarcode.util.Arrays;

public class JapanPost
extends Symbol {
    private static final String[] JAPAN_TABLE = new String[]{"FFT", "FDA", "DFA", "FAD", "FTF", "DAF", "AFD", "ADF", "TFF", "FTT", "TFT", "DAT", "DTA", "ADT", "TDA", "ATD", "TAD", "TTF", "FFF"};
    private static final char[] KASUT_SET = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h'};
    private static final char[] CH_KASUT_SET = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h'};

    public JapanPost() {
        this.humanReadableLocation = HumanReadableLocation.NONE;
    }

    @Override
    protected void encode() {
        int i;
        this.content = this.content.toUpperCase(Locale.ENGLISH);
        if (!this.content.matches("[0-9A-Z\\-]*")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        StringBuilder inter = new StringBuilder(40);
        for (i = 0; i < this.content.length() && inter.length() < 20; ++i) {
            char c = this.content.charAt(i);
            if (c >= '0' && c <= '9' || c == '-') {
                inter.append(c);
                continue;
            }
            if (c >= 'A' && c <= 'J') {
                inter.append('a');
                inter.append(CH_KASUT_SET[c - 65]);
                continue;
            }
            if (c >= 'K' && c <= 'O') {
                inter.append('b');
                inter.append(CH_KASUT_SET[c - 75]);
                continue;
            }
            if (c < 'U' || c > 'Z') continue;
            inter.append('c');
            inter.append(CH_KASUT_SET[c - 85]);
        }
        for (i = inter.length(); i < 20; ++i) {
            inter.append('d');
        }
        int sum = 0;
        int destLen = 67;
        StringBuilder dest = new StringBuilder(destLen);
        dest.append("FD");
        for (int i2 = 0; i2 < 20; ++i2) {
            dest.append(JAPAN_TABLE[Arrays.positionOf(inter.charAt(i2), KASUT_SET)]);
            sum += Arrays.positionOf(inter.charAt(i2), CH_KASUT_SET);
        }
        int check = 19 - sum % 19;
        if (check == 19) {
            check = 0;
        }
        dest.append(JAPAN_TABLE[Arrays.positionOf(CH_KASUT_SET[check], KASUT_SET)]);
        dest.append("DF");
        assert (dest.length() == destLen);
        this.infoLine("Encoding: " + dest);
        this.infoLine("Check Digit: " + check);
        this.readable = "";
        this.pattern = new String[]{dest.toString()};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    @Override
    protected void plotSymbol() {
        int x = 0;
        boolean w = true;
        int y = 0;
        int h = 0;
        this.resetPlotElements();
        for (int xBlock = 0; xBlock < this.pattern[0].length(); ++xBlock) {
            switch (this.pattern[0].charAt(xBlock)) {
                case 'A': {
                    y = 0;
                    h = 5;
                    break;
                }
                case 'D': {
                    y = 3;
                    h = 5;
                    break;
                }
                case 'F': {
                    y = 0;
                    h = 8;
                    break;
                }
                case 'T': {
                    y = 3;
                    h = 2;
                }
            }
            Rectangle rect = new Rectangle(x, y, (double)w, h);
            this.rectangles.add(rect);
            x += 2;
        }
        this.symbol_width = this.pattern[0].length() * 2;
        this.symbol_height = 8;
    }
}

