/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.util.Arrays;

public class Code3Of9
extends Symbol {
    private static final String[] CODE_39 = new String[]{"1112212111", "2112111121", "1122111121", "2122111111", "1112211121", "2112211111", "1122211111", "1112112121", "2112112111", "1122112111", "2111121121", "1121121121", "2121121111", "1111221121", "2111221111", "1121221111", "1111122121", "2111122111", "1121122111", "1111222111", "2111111221", "1121111221", "2121111211", "1111211221", "2111211211", "1121211211", "1111112221", "2111112211", "1121112211", "1111212211", "2211111121", "1221111121", "2221111111", "1211211121", "2211211111", "1221211111", "1211112121", "2211112111", "1221112111", "1212121111", "1212111211", "1211121211", "1112121211"};
    private static final char[] LOOKUP = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '-', '.', ' ', '$', '/', '+', '%'};
    private CheckDigit checkOption = CheckDigit.NONE;
    private double moduleWidthRatio = 2.0;

    public void setModuleWidthRatio(double moduleWidthRatio) {
        this.moduleWidthRatio = moduleWidthRatio;
    }

    public double getModuleWidthRatio() {
        return this.moduleWidthRatio;
    }

    public void setCheckDigit(CheckDigit checkMode) {
        this.checkOption = checkMode;
    }

    public CheckDigit getCheckDigit() {
        return this.checkOption;
    }

    @Override
    protected void encode() {
        if (!this.content.matches("[0-9A-Z\\. \\-$/+%]*")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        String start = "1211212111";
        String stop = "121121211";
        int patternLength = start.length() + stop.length() + 10 * this.content.length() + (this.checkOption == CheckDigit.MOD43 ? 10 : 0);
        StringBuilder dest = new StringBuilder(patternLength);
        dest.append(start);
        int counter = 0;
        char checkDigit = ' ';
        for (int i = 0; i < this.content.length(); ++i) {
            char c = this.content.charAt(i);
            int index = Arrays.positionOf(c, LOOKUP);
            dest.append(CODE_39[index]);
            counter += index;
        }
        if (this.checkOption == CheckDigit.MOD43) {
            checkDigit = LOOKUP[counter %= 43];
            int index = Arrays.positionOf(checkDigit, LOOKUP);
            dest.append(CODE_39[index]);
            if (checkDigit == ' ') {
                checkDigit = '_';
            }
            this.infoLine("Check Digit: " + checkDigit);
        }
        dest.append(stop);
        this.readable = this.checkOption == CheckDigit.MOD43 ? "*" + this.content + checkDigit + "*" : "*" + this.content + "*";
        this.pattern = new String[]{dest.toString()};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    @Override
    protected double getModuleWidth(int originalWidth) {
        if (originalWidth == 1) {
            return 1.0;
        }
        return this.moduleWidthRatio;
    }

    public static enum CheckDigit {
        NONE,
        MOD43;

    }
}

