/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.util.Arrays;

public class Codabar
extends Symbol {
    private static final String[] CODABAR_TABLE = new String[]{"11111221", "11112211", "11121121", "22111111", "11211211", "21111211", "12111121", "12112111", "12211111", "21121111", "11122111", "11221111", "21112121", "21211121", "21212111", "11212121", "11221211", "12121121", "11121221", "11122211"};
    private static final char[] CHARACTER_SET = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '$', ':', '/', '.', '+', 'A', 'B', 'C', 'D'};
    private double moduleWidthRatio = 2.0;

    public void setModuleWidthRatio(double moduleWidthRatio) {
        this.moduleWidthRatio = moduleWidthRatio;
    }

    public double getModuleWidthRatio() {
        return this.moduleWidthRatio;
    }

    @Override
    protected void encode() {
        if (!this.content.matches("[A-D]{1}[0-9:/\\$\\.\\+-]+[A-D]{1}")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        String horizontalSpacing = "";
        int l = this.content.length();
        for (int i = 0; i < l; ++i) {
            horizontalSpacing = horizontalSpacing + CODABAR_TABLE[Arrays.positionOf(this.content.charAt(i), CHARACTER_SET)];
        }
        this.readable = this.content;
        this.pattern = new String[]{horizontalSpacing};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    @Override
    protected double getModuleWidth(int originalWidth) {
        if (originalWidth == 1) {
            return 1.0;
        }
        return this.moduleWidthRatio;
    }

    @Override
    protected int[] getCodewords() {
        return this.getPatternAsCodewords(8);
    }
}

