/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import uk.org.okapibarcode.backend.HumanReadableLocation;
import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.ReedSolomon;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.graphics.Rectangle;
import uk.org.okapibarcode.util.Arrays;

public class AustraliaPost
extends Symbol {
    private static final char[] CHARACTER_SET = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', ' ', '#'};
    private static final String[] N_ENCODING_TABLE = new String[]{"00", "01", "02", "10", "11", "12", "20", "21", "22", "30"};
    private static final String[] C_ENCODING_TABLE = new String[]{"222", "300", "301", "302", "310", "311", "312", "320", "321", "322", "000", "001", "002", "010", "011", "012", "020", "021", "022", "100", "101", "102", "110", "111", "112", "120", "121", "122", "200", "201", "202", "210", "211", "212", "220", "221", "023", "030", "031", "032", "033", "103", "113", "123", "130", "131", "132", "133", "203", "213", "223", "230", "231", "232", "233", "303", "313", "323", "330", "331", "332", "333", "003", "013"};
    private static final String[] BAR_VALUE_TABLE = new String[]{"000", "001", "002", "003", "010", "011", "012", "013", "020", "021", "022", "023", "030", "031", "032", "033", "100", "101", "102", "103", "110", "111", "112", "113", "120", "121", "122", "123", "130", "131", "132", "133", "200", "201", "202", "203", "210", "211", "212", "213", "220", "221", "222", "223", "230", "231", "232", "233", "300", "301", "302", "303", "310", "311", "312", "313", "320", "321", "322", "323", "330", "331", "332", "333"};
    private Mode mode;

    public AustraliaPost() {
        this(Mode.POST);
    }

    public AustraliaPost(Mode mode) {
        this.mode = mode;
        this.humanReadableLocation = HumanReadableLocation.NONE;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    protected void encode() {
        int i;
        if (!this.content.matches("[0-9A-Za-z #]+")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        String formatControlCode = "00";
        block0 : switch (this.mode.ordinal()) {
            case 0: {
                switch (this.content.length()) {
                    case 8: {
                        formatControlCode = "11";
                        break block0;
                    }
                    case 13: {
                        formatControlCode = "59";
                        break block0;
                    }
                    case 16: {
                        formatControlCode = "59";
                        if (this.content.matches("[0-9]+")) break block0;
                        throw OkapiInputException.invalidCharactersInInput();
                    }
                    case 18: {
                        formatControlCode = "62";
                        break block0;
                    }
                    case 23: {
                        formatControlCode = "62";
                        if (this.content.matches("[0-9]+")) break block0;
                        throw OkapiInputException.invalidCharactersInInput();
                    }
                }
                throw new OkapiInputException("Input length must be one of 8, 13, 16, 18 or 23");
            }
            case 1: {
                if (this.content.length() > 8) {
                    throw OkapiInputException.inputTooLong();
                }
                formatControlCode = "45";
                break;
            }
            case 2: {
                if (this.content.length() > 8) {
                    throw OkapiInputException.inputTooLong();
                }
                formatControlCode = "87";
                break;
            }
            case 3: {
                if (this.content.length() > 8) {
                    throw OkapiInputException.inputTooLong();
                }
                formatControlCode = "92";
            }
        }
        this.infoLine("FCC: " + formatControlCode);
        StringBuilder zeroPaddedInput = new StringBuilder();
        if (this.mode != Mode.POST) {
            for (int i2 = this.content.length(); i2 < 8; ++i2) {
                zeroPaddedInput.append('0');
            }
        }
        zeroPaddedInput.append(this.content);
        String deliveryPointId = zeroPaddedInput.substring(0, 8);
        if (!deliveryPointId.matches("[0-9]+")) {
            throw new OkapiInputException("Invalid characters in DPID");
        }
        this.infoLine("DPID: " + deliveryPointId);
        StringBuilder barStateValues = new StringBuilder();
        barStateValues.append("13");
        for (i = 0; i < 2; ++i) {
            barStateValues.append(N_ENCODING_TABLE[formatControlCode.charAt(i) - 48]);
        }
        for (i = 0; i < 8; ++i) {
            barStateValues.append(N_ENCODING_TABLE[deliveryPointId.charAt(i) - 48]);
        }
        switch (zeroPaddedInput.length()) {
            case 13: 
            case 18: {
                for (i = 8; i < zeroPaddedInput.length(); ++i) {
                    barStateValues.append(C_ENCODING_TABLE[Arrays.positionOf(zeroPaddedInput.charAt(i), CHARACTER_SET)]);
                }
                break;
            }
            case 16: 
            case 23: {
                for (i = 8; i < zeroPaddedInput.length(); ++i) {
                    barStateValues.append(N_ENCODING_TABLE[Arrays.positionOf(zeroPaddedInput.charAt(i), CHARACTER_SET)]);
                }
                break;
            }
        }
        switch (barStateValues.length()) {
            case 22: 
            case 37: 
            case 52: {
                barStateValues.append('3');
            }
        }
        barStateValues.append(this.calcReedSolomon(barStateValues));
        barStateValues.append("13");
        this.infoLine("Total Length: " + barStateValues.length());
        this.info("Encoding: ");
        block31: for (i = 0; i < barStateValues.length(); ++i) {
            switch (barStateValues.charAt(i)) {
                case '1': {
                    this.info('A');
                    continue block31;
                }
                case '2': {
                    this.info('D');
                    continue block31;
                }
                case '0': {
                    this.info('F');
                    continue block31;
                }
                case '3': {
                    this.info('T');
                }
            }
        }
        this.infoLine();
        this.readable = "";
        this.pattern = new String[]{barStateValues.toString()};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    private CharSequence calcReedSolomon(CharSequence oldBarStateValues) {
        int tripleValueCount = 0;
        int[] tripleValue = new int[31];
        int barStateCount = 2;
        while (barStateCount < oldBarStateValues.length()) {
            tripleValue[tripleValueCount] = this.barStateToDecimal(oldBarStateValues.charAt(barStateCount), 4) + this.barStateToDecimal(oldBarStateValues.charAt(barStateCount + 1), 2) + this.barStateToDecimal(oldBarStateValues.charAt(barStateCount + 2), 0);
            barStateCount += 3;
            ++tripleValueCount;
        }
        ReedSolomon rs = new ReedSolomon();
        rs.init_gf(67);
        rs.init_code(4, 1);
        rs.encode(tripleValueCount, tripleValue);
        StringBuilder newBarStateValues = new StringBuilder();
        for (barStateCount = 4; barStateCount > 0; --barStateCount) {
            newBarStateValues.append(BAR_VALUE_TABLE[rs.getResult(barStateCount - 1)]);
        }
        return newBarStateValues;
    }

    private int barStateToDecimal(char oldBarStateValues, int shift) {
        return oldBarStateValues - 48 << shift;
    }

    @Override
    protected void plotSymbol() {
        int x = 0;
        boolean w = true;
        int y = 0;
        int h = 0;
        this.resetPlotElements();
        for (int xBlock = 0; xBlock < this.pattern[0].length(); ++xBlock) {
            switch (this.pattern[0].charAt(xBlock)) {
                case '1': {
                    y = 0;
                    h = 5;
                    break;
                }
                case '2': {
                    y = 3;
                    h = 5;
                    break;
                }
                case '0': {
                    y = 0;
                    h = 8;
                    break;
                }
                case '3': {
                    y = 3;
                    h = 2;
                }
            }
            Rectangle rect = new Rectangle(x, y, (double)w, h);
            this.rectangles.add(rect);
            x += 2;
        }
        this.symbol_width = (this.pattern[0].length() - 1) * 2 + 1;
        this.symbol_height = 8;
    }

    public static enum Mode {
        POST,
        REPLY,
        ROUTE,
        REDIRECT;

    }
}

