/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.resource.construct.xml;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.lib.resource.construct.xml.ScopeParserFactory;
import java.util.List;
import javax.annotation.Nonnull;

public class ScriptParser
implements ElementParser {
    @Override
    @Nonnull
    public ClassObjectPair parse(@Nonnull Element element, @Nonnull ParserFactory factory) throws ElementParserException {
        ClassObjectPair lastCOP = null;
        List<Element> children = element.getChildElements();
        if (children.size() > 0) {
            ScopeParserFactory scopeFactory = new ScopeParserFactory(factory);
            for (Element child : children) {
                String tagName = child.getNodeName();
                if (tagName.equals("return")) {
                    Element objTag = child.getChildElements().get(0);
                    try {
                        lastCOP = scopeFactory.getParser(objTag.getNodeName()).parse(objTag, scopeFactory);
                        return lastCOP;
                    }
                    catch (ParserNotRegisteredException ex) {
                        throw new ElementParserException(ex);
                    }
                }
                try {
                    lastCOP = scopeFactory.getParser(child.getNodeName()).parse(child, scopeFactory);
                }
                catch (ParserNotRegisteredException ex) {
                    throw new ElementParserException(ex);
                }
            }
        }
        if (lastCOP == null) {
            throw new ElementParserException("no child elements defined for element " + element.getNodeName());
        }
        return lastCOP;
    }
}

