/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.vision.util;

import com.java4less.vision.RImage;

public class Histogram {
    private int MAX = 256;
    private int[] histogram = new int[this.MAX];
    private RImage image;

    public Histogram(RImage im) {
        this.image = im;
        int w = this.image.getWidth();
        int h = this.image.getHeight();
        boolean isGrey = this.image.getImage().getType() == 10;
        int count = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                ++count;
                if (isGrey) {
                    int n = this.image.getPixel(y, x);
                    this.histogram[n] = this.histogram[n] + 1;
                    continue;
                }
                double v = (double)this.image.getRPixel(y, x) * 0.3333 + (double)this.image.getGPixel(y, x) * 0.3333 + (double)this.image.getBPixel(y, x) * 0.3333 + 0.5;
                int n = (int)v;
                this.histogram[n] = this.histogram[n] + 1;
            }
        }
    }

    public void stretch() {
        int hmin = 0;
        int hmax = 0;
        int saturated = 10;
        int threshold = (double)saturated > 0.0 ? (int)((double)(this.image.getWidth() * this.image.getHeight() * saturated) / 200.0) : 0;
        int i = -1;
        boolean found = false;
        int count = 0;
        do {
            boolean bl = found = (count += this.histogram[++i]) > threshold;
        } while (!found && i < 255);
        hmin = i;
        i = 256;
        count = 0;
        do {
            boolean bl = found = (count += this.histogram[--i]) > threshold;
        } while (!found && i > 0);
        hmax = i;
        if (hmax <= hmin) {
            return;
        }
        int[] lookupTable = new int[256];
        for (int j = 0; j < 256; ++j) {
            int v = j - hmin;
            if ((v = (int)(256.0 * (double)v / (double)(hmax - hmin))) < 0) {
                v = 0;
            }
            if (v > 255) {
                v = 255;
            }
            lookupTable[j] = v;
        }
        int w = this.image.getWidth();
        int h = this.image.getHeight();
        int c = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                ++c;
                int r = lookupTable[this.image.getRPixel(y, x)];
                int g = lookupTable[this.image.getGPixel(y, x)];
                int b = lookupTable[this.image.getBPixel(y, x)];
                this.image.setRPixel(y, x, r);
                this.image.setGPixel(y, x, g);
                this.image.setBPixel(y, x, b);
            }
        }
    }

    public void equalize() {
        int w = this.image.getWidth();
        int h = this.image.getHeight();
        int[] normalized = new int[this.MAX];
        int sum = 0;
        double multiplier = (double)(this.MAX - 1) / (double)(w * h);
        for (int i = 0; i < this.MAX; ++i) {
            normalized[i] = (int)Math.round((double)(sum += this.histogram[i]) * multiplier);
        }
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                this.image.setPixel(y, x, normalized[this.image.getPixel(y, x)]);
            }
        }
    }

    public int getThreshold() {
        long t = 0L;
        long tnew = 128L;
        long c = 0L;
        int iteration = 0;
        long tmpi = 0L;
        try {
            while (tnew != t) {
                ++iteration;
                t = tnew;
                double m2 = 0.0;
                double m1 = 0.0;
                int i = 0;
                while ((long)i < t) {
                    m1 += (double)(this.histogram[i] * i);
                    c += (long)this.histogram[i];
                    ++i;
                }
                m1 = c == 0L ? (double)t : (m1 /= (double)c);
                c = 0L;
                for (i = (int)t; i < this.MAX; ++i) {
                    tmpi = i;
                    m2 += (double)(this.histogram[i] * i);
                    c += (long)this.histogram[i];
                }
                m2 = c == 0L ? (double)t : (m2 /= (double)c);
                tnew = (int)((m1 + m2) / 2.0);
                if (iteration <= 40) continue;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage() + " i=" + tmpi);
        }
        return (int)tnew;
    }
}

