/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.vision.recognition;

import com.java4less.vision.RImage;
import com.java4less.vision.recognition.AreaWalker;
import com.java4less.vision.recognition.Line;
import com.java4less.vision.recognition.Point;
import java.util.Vector;

public class ImageObject {
    Point startPoint = null;
    Point centerOfMass = null;
    int area = 0;
    private Line longPA = null;
    Line realPA = null;
    Point[] perimeterPixels;
    double maxLength = 0.0;
    Point nearestCorner = new Point(999999.0, 999999.0);
    double nearestCornerDistance = 999999.0;
    protected Point farestCorner = new Point(0.0, 0.0);
    double farestCornerDistance = 0.0;
    public double minX = 1000000.0;
    public double minY = 1000000.0;
    public double maxY = 0.0;
    public double maxX = 0.0;

    public ImageObject(RImage image, Point p) {
        this.startPoint = p;
        this.initialize(image, p);
    }

    private void initialize(RImage image, Point start) {
        AreaWalker walker = new AreaWalker(image, start, false);
        double c1 = 0.0;
        double c2 = 0.0;
        this.minX = start.x;
        this.maxX = start.x;
        this.minY = start.y;
        this.maxY = start.y;
        this.area = 0;
        Vector<Point> v = new Vector<Point>();
        Point p = walker.getNextPoint();
        while (p != null) {
            double distanceToOrigin;
            if (p.x < this.minX) {
                this.minX = p.x;
            }
            if (p.y < this.minY) {
                this.minY = p.y;
            }
            if (p.x > this.maxX) {
                this.maxX = p.x;
            }
            if (p.y > this.maxY) {
                this.maxY = p.y;
            }
            if ((distanceToOrigin = Math.sqrt(p.x * p.x + p.y * p.y)) < this.nearestCornerDistance) {
                this.nearestCornerDistance = distanceToOrigin;
                this.nearestCorner = p;
            }
            if (distanceToOrigin > this.farestCornerDistance) {
                this.farestCornerDistance = distanceToOrigin;
                this.farestCorner = p;
            }
            ++this.area;
            c1 += (double)((int)p.y);
            c2 += (double)((int)p.x);
            if (image.isInPerimeter4(p)) {
                v.add(p);
            }
            p = walker.getNextPoint();
        }
        this.perimeterPixels = new Point[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            this.perimeterPixels[i] = (Point)v.elementAt(i);
        }
        this.centerOfMass = new Point(c2 / (double)this.area, c1 / (double)this.area);
    }

    public Point getStarPoint() {
        return this.startPoint;
    }

    public Point getCenterOfMass() {
        return this.centerOfMass;
    }

    public int getArea() {
        return this.area;
    }

    public Line getPA() {
        return this.realPA;
    }

    public void calculatePA(RImage image) {
        double pointLen;
        Point p;
        int i;
        long prv = System.currentTimeMillis();
        if (this.longPA != null) {
            return;
        }
        double dmax = -1.0;
        Point selected = null;
        for (int i2 = 0; i2 < this.perimeterPixels.length; ++i2) {
            Line line;
            double dd;
            Point p2 = this.perimeterPixels[i2];
            if (!(p2.y <= this.centerOfMass.y + 0.5) || !((dd = this.calculateDistances(image, line = new Line(this.centerOfMass.x, this.centerOfMass.y, p2.x, p2.y), dmax)) < dmax) && dmax != -1.0) continue;
            dmax = dd;
            selected = p2;
        }
        prv = System.currentTimeMillis();
        Line best = new Line(this.centerOfMass.x, this.centerOfMass.y, selected.x, selected.y);
        double len = selected.distanceTo(this.centerOfMass);
        dmax = -1.0;
        Point selected2 = this.centerOfMass;
        double maxLen = 0.0;
        for (i = 0; i < this.perimeterPixels.length; ++i) {
            Line line;
            double dd;
            p = this.perimeterPixels[i];
            if (!(p.y >= this.centerOfMass.y - 0.5) || !((pointLen = selected.distanceTo(p)) > len) || !((dd = this.calculateDistances(image, line = new Line(selected.x, selected.y, p.x, p.y), dmax)) < dmax) && dmax != -1.0) continue;
            dmax = dd;
            selected2 = p;
        }
        maxLen = 0.0;
        best = this.realPA = new Line(selected.x, selected.y, selected2.x, selected2.y);
        for (i = 0; i < this.perimeterPixels.length; ++i) {
            double dist;
            p = this.perimeterPixels[i];
            if (!(p.y >= this.centerOfMass.y - 0.5) || !((pointLen = selected.distanceTo(p)) > len) || !((dist = best.getDistance(p)) <= 1.0) || !(pointLen > maxLen)) continue;
            selected2 = p;
            maxLen = pointLen;
        }
        maxLen = 0.0;
        for (i = 0; i < this.perimeterPixels.length; ++i) {
            double dist;
            p = this.perimeterPixels[i];
            if (!(p.y <= this.centerOfMass.y + 0.5) || !((pointLen = selected2.distanceTo(p)) > len) || !((dist = best.getDistance(p)) <= 1.0) || !(pointLen > maxLen)) continue;
            selected = p;
            maxLen = pointLen;
        }
        this.longPA = new Line(selected.x, selected.y, selected2.x, selected2.y);
        this.maxLength = this.longPA.getLength();
        this.perimeterPixels = null;
    }

    private double calculateMaxDistance(RImage image, Point p) {
        double max = 0.0;
        for (int i = 0; i < this.perimeterPixels.length; ++i) {
            Point p2 = this.perimeterPixels[i];
            double d = p.distanceTo(p2);
            if (!(d > max)) continue;
            max = d;
        }
        return max;
    }

    private double calculateDistances(RImage image, Line line, double currentMax) {
        double sum = 0.0;
        double max = 0.0;
        for (int i = 0; i < this.perimeterPixels.length; ++i) {
            Point p = this.perimeterPixels[i];
            double d = line.getDistance(p);
            sum += d * d;
            if (currentMax == -1.0 || !(sum > currentMax)) continue;
            return currentMax + 1.0;
        }
        return sum;
    }

    public boolean isAligned(ImageObject object) {
        double tmp;
        Line perp = this.getPA().getPerp();
        double alignedDistance = perp.getDistance(object.getCenterOfMass());
        return alignedDistance < (tmp = 0.4 * Math.abs(this.maxLength));
    }

    public double getLength() {
        return this.maxLength;
    }
}

