/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.vision.recognition;

import com.java4less.vision.RImage;
import com.java4less.vision.recognition.Barcode1DObject;
import com.java4less.vision.recognition.ImageObject;
import com.java4less.vision.recognition.Line;
import com.java4less.vision.recognition.Point;
import com.java4less.vision.recognition.VectorizedImage;
import java.util.Vector;

public class Barcode1DFinder {
    public int minbars = 6;
    public int minBarLength = Integer.parseInt(System.getProperty("com.java4less.vision.minbarlength", "15"));
    public int maxBarLength = Integer.parseInt(System.getProperty("com.java4less.vision.maxbarlength", "1000"));
    private boolean debug = System.getProperty("com.java4less.vision.debug", "0").equals("1");
    public int quiteZoneMultiplier = Integer.parseInt(System.getProperty("com.java4less.vision.quitezone", "6"));
    public boolean supportBrokenBars = System.getProperty("com.java4less.vision.brokenbars", "1").equals("1");
    protected double minDistanceMult = Double.parseDouble(System.getProperty("com.java4less.vision.brokenbars", "0.5"));
    public int angleDif = Integer.parseInt(System.getProperty("com.java4less.vision.angledif", "5"));
    RImage rimage;

    public Vector findBarcodes(VectorizedImage image, RImage im) {
        this.rimage = im;
        Vector objects = image.getObjects();
        Vector<Barcode1DObject> candidates = new Vector<Barcode1DObject>();
        while (objects.size() > 0) {
            Vector unsorted = this.getParallelObjectsSet(objects);
            if (unsorted.size() <= 0) continue;
            Vector set = this.sortParallelAlignedObjects(unsorted);
            this.calculateDistances(set);
            if (set.size() <= this.minbars) continue;
            Vector groups = this.getGroupsOfObjects(set);
            for (int i = 0; i < groups.size(); ++i) {
                candidates.add(new Barcode1DObject((Vector)groups.elementAt(i)));
            }
        }
        return candidates;
    }

    private Vector sortParallelAlignedObjects(Vector objects) {
        Line first = ((ImageObject)objects.elementAt(0)).getPA();
        Line xAxis = new Line(0.0, 0.0, 1.0, 0.0);
        Line yAxis = new Line(0.0, 0.0, 0.0, 1.0);
        Line perp = first.getPerp();
        Line axis = xAxis;
        double angle = perp.getAngle();
        if (Math.abs(angle % 360.0) < 25.0) {
            axis = yAxis;
        }
        if (Math.abs(angle % 360.0) > 335.0) {
            axis = yAxis;
        }
        if (Math.abs(angle % 360.0) < 205.0 && Math.abs(angle % 360.0) > 155.0) {
            axis = yAxis;
        }
        Vector<Double> distances = new Vector<Double>();
        Vector<ImageObject> sorted = new Vector<ImageObject>();
        Point referencePoint = axis.getIntersect(perp);
        for (int i = 0; i < objects.size(); ++i) {
            ImageObject object = (ImageObject)objects.elementAt(i);
            Line line = object.getPA();
            double dist = line.getDistance(referencePoint);
            int position = distances.size();
            for (int j = 0; j < distances.size(); ++j) {
                if (!((Double)distances.elementAt(j) > dist)) continue;
                position = j;
                break;
            }
            distances.add(position, new Double(dist));
            sorted.add(position, object);
        }
        int j = distances.size() - 1;
        double firstBarWidth = (double)((ImageObject)sorted.elementAt(0)).getArea() / ((ImageObject)sorted.elementAt(0)).getLength();
        double minDistance = firstBarWidth * this.minDistanceMult;
        if (minDistance < 1.5) {
            minDistance = 1.5;
        }
        if (this.supportBrokenBars) {
            while (j > 0) {
                double previous = (Double)distances.elementAt(j - 1);
                double current = (Double)distances.elementAt(j);
                if (current - previous < minDistance) {
                    ImageObject pobject = (ImageObject)sorted.elementAt(j - 1);
                    ImageObject cobject = (ImageObject)sorted.elementAt(j);
                    if (cobject.getLength() > pobject.getLength()) {
                        distances.removeElementAt(j - 1);
                        sorted.removeElementAt(j - 1);
                        this.addDebug("Removing bar, distance too small " + (current - previous) + " < " + minDistance);
                    } else {
                        distances.removeElementAt(j);
                        sorted.removeElementAt(j);
                    }
                }
                --j;
            }
        }
        return sorted;
    }

    private boolean compareAngles(double a1, double a2, double diff) {
        if (Math.abs(a1 - a2) < diff) {
            return true;
        }
        double tmp = a1 + 180.0;
        if (tmp > 360.0) {
            tmp -= 360.0;
        }
        if (Math.abs(tmp - a2) < diff) {
            return true;
        }
        tmp = a2 + 180.0;
        if (tmp > 360.0) {
            tmp -= 360.0;
        }
        return Math.abs(a1 - tmp) < diff;
    }

    private Vector getParallelObjectsSet(Vector objects) {
        int i;
        Vector<ImageObject> result = new Vector<ImageObject>();
        Vector<Integer> resultIndexes = new Vector<Integer>();
        ImageObject first = (ImageObject)objects.elementAt(0);
        while (first.getLength() < (double)this.minBarLength || first.getLength() > (double)this.maxBarLength) {
            objects.removeElementAt(0);
            if (objects.size() == 0) {
                return result;
            }
            first = (ImageObject)objects.elementAt(0);
        }
        ImageObject lastAccepted = first;
        result.add(first);
        resultIndexes.add(new Integer(0));
        for (i = 1; i < objects.size(); ++i) {
            ImageObject object = (ImageObject)objects.elementAt(i);
            Line line = object.getPA();
            if (this.compareAngles(line.getAngle(), first.getPA().getAngle(), this.angleDif)) {
                double ratio = first.getLength() / object.getLength();
                if (ratio < 1.0) {
                    ratio = object.getLength() / first.getLength();
                }
                if (ratio < 5.0 && object.getLength() > (double)this.minBarLength && object.getLength() < (double)this.maxBarLength) {
                    if (lastAccepted.isAligned(object) || first.isAligned(object)) {
                        result.add(object);
                        resultIndexes.add(new Integer(i));
                        lastAccepted = object;
                        continue;
                    }
                    this.addDebug("Not aligned");
                    continue;
                }
                this.addDebug("Not long enough " + object.getLength());
                continue;
            }
            this.addDebug("Not same angle " + object.getPA().getAngle() + "  <> " + first.getPA().getAngle() + " length " + first.getLength());
        }
        for (i = resultIndexes.size() - 1; i >= 0; --i) {
            objects.removeElementAt((Integer)resultIndexes.elementAt(i));
        }
        return result;
    }

    private void addDebug(String s) {
        if (this.debug) {
            System.out.println(s);
        }
    }

    private void calculateDistances(Vector result) {
        for (int i = 0; i < result.size() - 1; ++i) {
            Line line = ((ImageObject)result.elementAt(i)).getPA();
            Line line2 = ((ImageObject)result.elementAt(i + 1)).getPA();
            line2.distanceToNextLine = 0.0;
            line.distanceToNextLine = line.getDistance(new Point(line2.x1, line2.y1));
        }
    }

    private Vector getGroupsOfObjects(Vector parallelObjects) {
        int minLine = this.getMinDistanceLine(parallelObjects);
        Vector groups = new Vector();
        while (minLine != -1) {
            Vector<ImageObject> group = new Vector<ImageObject>();
            double minDistance = ((ImageObject)parallelObjects.elementAt((int)minLine)).getPA().distanceToNextLine;
            int startLine = minLine;
            int i = minLine - 1;
            while (i >= 0) {
                ImageObject object = (ImageObject)parallelObjects.elementAt(i);
                Line line = ((ImageObject)parallelObjects.elementAt(i)).getPA();
                if (line.marked || line.distanceToNextLine > minDistance * (double)this.quiteZoneMultiplier) break;
                line.marked = true;
                group.add(0, object);
                startLine = i--;
            }
            int endLine = minLine;
            int i2 = minLine;
            while (i2 < parallelObjects.size()) {
                ImageObject object = (ImageObject)parallelObjects.elementAt(i2);
                Line line = ((ImageObject)parallelObjects.elementAt(i2)).getPA();
                if (line.marked) break;
                line.marked = true;
                group.add(object);
                endLine = i2++;
                if (line.distanceToNextLine > minDistance * (double)this.quiteZoneMultiplier) break;
            }
            if (group.size() >= this.minbars) {
                groups.add(group);
            }
            minLine = this.getMinDistanceLine(parallelObjects);
        }
        return groups;
    }

    private int getMinDistanceLine(Vector objects) {
        double min = 999999.0;
        int minLine = -1;
        for (int i = 0; i < objects.size(); ++i) {
            Line line = ((ImageObject)objects.elementAt(i)).getPA();
            if (line.marked || !(min > line.distanceToNextLine) || !(line.distanceToNextLine > 0.0)) continue;
            minLine = i;
            min = line.distanceToNextLine;
        }
        return minLine;
    }
}

