/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.pdfforms;

import ch.dvbern.lib.pdfforms.FormattingParams;
import ch.dvbern.lib.pdfforms.Page;
import ch.dvbern.lib.pdfforms.PdfField;
import ch.dvbern.lib.pdfforms.PdfFormFieldParser;
import ch.dvbern.lib.pdfforms.processing.ProcessorException;
import ch.dvbern.lib.pdfforms.processing.ProcessorOperation;
import ch.dvbern.lib.pdfforms.processing.ProcessorParams;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfSmartCopy;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.XfaForm;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PdfFormFiller {
    private static final Logger LOG = LoggerFactory.getLogger(PdfFormFiller.class);
    private static final ConcurrentHashMap<URI, byte[]> fontBytesCache = new ConcurrentHashMap();

    public @NonNull byte[] convertPageToPDF(@NonNull PageInput page, boolean flatten) throws IOException, DocumentException, MalformedURLException {
        FormattingParams params = page.getPage().getFormattingParams();
        LOG.debug("Creating PDF: {}", (Object)params);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PdfStamper stamper = new PdfStamper(page.getPdfReader(), (OutputStream)outputStream);
        this.dumpFieldNames(stamper);
        LOG.debug("Replacing placeholders in PDF with values.");
        if (stamper.getAcroFields().getXfa().isXfaPresent()) {
            LOG.debug("XFA present");
        }
        RuntimeException fieldError = null;
        for (Map.Entry<String, String> entry : page.getPage().getFieldValues().entrySet()) {
            LOG.trace("Field: {}=<{}>", (Object)entry.getKey(), (Object)entry.getValue());
            try {
                this.fillPdfField(stamper, entry.getKey(), entry.getValue());
            }
            catch (RuntimeException e) {
                LOG.error("Field in Error: {}:{}", (Object)params.getTemplateURL(), (Object)entry.getKey());
                fieldError = e;
            }
        }
        if (fieldError != null) {
            throw fieldError;
        }
        this.performPostProcessing(page, stamper);
        page.getPage().getEmbeddableFontFiles().forEach(font -> this.embedFont(stamper.getReader(), stamper.getWriter(), (URI)font));
        stamper.getWriter().setPdfVersion(PdfWriter.PDF_VERSION_1_4);
        stamper.getWriter().setPDFXConformance(3);
        if (flatten) {
            this.flattenPdfForm(stamper);
        }
        stamper.close();
        LOG.debug("Replacements in PDF performed.");
        return outputStream.toByteArray();
    }

    private void logFieldName(@NonNull String prefix, @Nullable String fieldId, @Nullable String value) {
        String val = "stek.get";
        if (value != null && !value.isEmpty()) {
            val = '\"' + value + '\"';
        }
    }

    public String getFieldValue(@NonNull PdfStamper stamper, @NonNull PdfField field) {
        switch (field.getFieldType()) {
            case ACROFIELD: {
                return stamper.getAcroFields().getField(field.getNameFullyQualified());
            }
            case XFA_FIELD: {
                throw new NotImplementedException("Not yet implemented for XFA. See fillPdfField() for ideas.");
            }
        }
        throw new NotImplementedException("Field type not implemented: " + (Object)((Object)field.getFieldType()));
    }

    private void dumpFieldNames(@NonNull PdfStamper stamper) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        HashMap fields = stamper.getAcroFields().getFields();
        for (Object object : fields.keySet()) {
            this.logFieldName("AcroField", PdfFormFieldParser.prettyprintAcroFieldName(PdfFormFieldParser.unescapePdfFormItemKey((String)object)), stamper.getAcroFields().getField(object.toString()));
        }
        XfaForm xfa = stamper.getAcroFields().getXfa();
        int fieldCount = 0;
        int namedFieldCount = 0;
        if (xfa.isXfaPresent()) {
            org.w3c.dom.Document domDoc = xfa.getDomDocument();
            NodeList nodeList = domDoc.getElementsByTagName("field");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String fieldName;
                ++fieldCount;
                Node node = nodeList.item(i);
                Node fieldNameNode = node.getAttributes().getNamedItem("name");
                if (fieldNameNode == null || (fieldName = fieldNameNode.getNodeValue()) == null || fieldName.isEmpty()) continue;
                ++namedFieldCount;
                this.logFieldName("XFAField", fieldName, node.getTextContent());
            }
        }
        LOG.debug("XFA-Named-Nodes: {}/{}", (Object)namedFieldCount, (Object)fieldCount);
    }

    private void fillPdfField(@NonNull PdfStamper stamper, @NonNull String fieldName, @Nullable String fieldValue) throws IOException, DocumentException {
        AcroFields acroFields = stamper.getAcroFields();
        String escapedField = XfaForm.Xml2Som.escapeSom((String)fieldName);
        if (!acroFields.getXfa().isXfaPresent()) {
            acroFields.setField(fieldName, fieldValue);
            LOG.trace("PDF with XFA NOT present");
        } else {
            LOG.trace("PDF with XFA present");
            XfaForm xfa = acroFields.getXfa();
            String name = xfa.findFieldName(escapedField, acroFields);
            if (name == null) {
                throw new IllegalArgumentException("Fieldname not found: (" + escapedField + ')');
            }
            String shortName = XfaForm.Xml2Som.getShortName((String)name);
            if (xfa.findDatasetsNode(shortName) == null && xfa.findDatasetsNode(escapedField) == null) {
                xfa.getDatasetsSom().insertNode(xfa.getDatasetsNode(), shortName);
            }
            acroFields.setField(escapedField, fieldValue);
        }
    }

    public @Nullable byte[] createPDF(@NonNull Collection<@NonNull Page> allPages, boolean flatten) throws DocumentException, IOException, MalformedURLException {
        if (allPages.isEmpty()) {
            return null;
        }
        ArrayList<PageInput> pages = new ArrayList<PageInput>(allPages.size());
        try {
            for (Page page : allPages) {
                pages.add(new PageInput(page));
            }
            int totalPages = 0;
            for (PageInput page : pages) {
                totalPages += page.getNumberOfPages();
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Document document = new Document();
            PdfSmartCopy copy = new PdfSmartCopy(document, (OutputStream)byteArrayOutputStream);
            copy.setPdfVersion(PdfWriter.PDF_VERSION_1_4);
            copy.setPDFXConformance(3);
            document.open();
            int pageNum = 1;
            for (PageInput page : pages) {
                page.getPage().getFormattingParams().getPageNumberingAlgo().updatePageNumber(page.getPage(), pageNum, totalPages);
                pageNum += page.getNumberOfPages();
                byte[] pdfAsByteArray = this.convertPageToPDF(page, flatten);
                LOG.debug("PDF length in bytes = {}", (Object)pdfAsByteArray.length);
                PdfReader reader = new PdfReader(pdfAsByteArray);
                for (int i = 1; i <= reader.getNumberOfPages(); ++i) {
                    copy.addPage(copy.getImportedPage(reader, i));
                }
                reader.close();
            }
            document.close();
            copy.close();
            byteArrayOutputStream.close();
            byte[] bytes = byteArrayOutputStream.toByteArray();
            return bytes;
        }
        catch (IOException | RuntimeException e) {
            for (PageInput page : pages) {
                page.close();
            }
            throw e;
        }
    }

    private void performPostProcessing(@NonNull PageInput page, @NonNull PdfStamper pdfStamper) throws ProcessorException {
        Objects.requireNonNull(page);
        Objects.requireNonNull(pdfStamper);
        for (ProcessorOperation processor : page.getPage().getFormattingParams().getPostProcessors()) {
            processor.apply(new ProcessorParams(pdfStamper, page.getPage().getFormattingParams()));
        }
    }

    private void flattenPdfForm(@NonNull PdfStamper stamper) {
        AcroFields acroFields = stamper.getAcroFields();
        XfaForm xfa = acroFields.getXfa();
        stamper.setFormFlattening(true);
        if (!xfa.isXfaPresent()) {
            LOG.debug("PDF with XFA NOT present");
        } else {
            LOG.debug("PDF with XFA present");
            org.w3c.dom.Document domDoc = xfa.getDomDocument();
            NodeList nodeList = domDoc.getElementsByTagName("field");
            LOG.debug("number of fields = {}", (Object)nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                Element e = (Element)node;
                e.setAttribute("access", "readOnly");
            }
            xfa.setChanged(true);
        }
    }

    private void embedFont(@NonNull PdfReader reader, @NonNull PdfWriter writer, @NonNull URI fontURI) {
        Objects.requireNonNull(reader);
        Objects.requireNonNull(writer);
        Objects.requireNonNull(fontURI);
        boolean added = false;
        try {
            byte[] fontBytes = this.getCachedFontBytes(fontURI);
            PdfStream pdfFontStream = new PdfStream(fontBytes);
            String fontFilename = FilenameUtils.getName((String)fontURI.getPath());
            BaseFont font = BaseFont.createFont((String)fontFilename, (String)"Cp1252", (boolean)true, (boolean)true, (byte[])fontBytes, null);
            PdfName fontName = new PdfName(font.getPostscriptFontName());
            PdfIndirectObject objref = writer.addToBody((PdfObject)pdfFontStream);
            int n = reader.getXrefSize();
            for (int i = 0; i < n; ++i) {
                PdfDictionary fontDict;
                PdfObject object = reader.getPdfObject(i);
                if (object == null || !object.isDictionary() || !PdfName.FONTDESCRIPTOR.equals((Object)(fontDict = (PdfDictionary)object).get(PdfName.TYPE)) || !fontName.toString().toLowerCase().equals(fontDict.get(PdfName.FONTNAME).toString().toLowerCase())) continue;
                fontDict.put(PdfName.FONTFILE2, (PdfObject)objref.getIndirectReference());
                added = true;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not embed font: " + fontURI, e);
        }
        if (!added) {
            throw new IllegalStateException("Font not embedded: " + fontURI);
        }
    }

    private @NonNull byte[] getCachedFontBytes(@NonNull URI uri) {
        return fontBytesCache.computeIfAbsent(uri, entry -> {
            try {
                return IOUtils.toByteArray((URI)uri);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read uri: " + uri, e);
            }
        });
    }

    private static class PageInput
    implements Closeable {
        private final @NonNull Page page;
        private final @NonNull PdfReader pdfReader;
        private final int numberOfPages;

        public PageInput(@NonNull Page page) throws IOException {
            this.page = page;
            URL templateURL = page.getFormattingParams().getTemplateURL();
            try (BufferedInputStream templateConnection = new BufferedInputStream(templateURL.openConnection().getInputStream());){
                this.pdfReader = new PdfReader((InputStream)templateConnection);
                this.numberOfPages = this.pdfReader.getNumberOfPages();
            }
        }

        @Override
        public void close() throws IOException {
            this.pdfReader.close();
        }

        public @NonNull Page getPage() {
            return this.page;
        }

        public @NonNull PdfReader getPdfReader() {
            return this.pdfReader;
        }

        public int getNumberOfPages() {
            return this.numberOfPages;
        }
    }
}

