/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.pdfforms;

import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PdfField
implements Serializable,
Comparable<PdfField> {
    private static final long serialVersionUID = 1085517957184991673L;
    private final @NonNull FieldType fieldType;
    private final @NonNull String name;
    private final @NonNull String nameFullyQualified;

    @Override
    public int compareTo(@Nullable PdfField that) {
        if (that == null) {
            return -1;
        }
        if (this.name.compareTo(that.name) < 0) {
            return -1;
        }
        if (this.name.compareTo(that.name) > 0) {
            return 1;
        }
        if (this.fieldType.compareTo(that.fieldType) < 0) {
            return -1;
        }
        if (this.nameFullyQualified.compareTo(that.nameFullyQualified) < 0) {
            return -1;
        }
        if (this.nameFullyQualified.compareTo(that.nameFullyQualified) > 0) {
            return 1;
        }
        return 0;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdfField other = (PdfField)o;
        return 0 == this.compareTo(other);
    }

    public int hashCode() {
        int result = this.fieldType.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.nameFullyQualified.hashCode();
        return result;
    }

    public @NonNull String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("fieldType", (Object)this.fieldType).append("name", (Object)this.name).append("nameFQ", (Object)this.nameFullyQualified).toString();
    }

    public PdfField(@NonNull FieldType fieldType, @NonNull String name, @NonNull String nameFullyQualified) {
        this.fieldType = Objects.requireNonNull(fieldType);
        this.name = Objects.requireNonNull(name);
        this.nameFullyQualified = Objects.requireNonNull(nameFullyQualified);
    }

    public @NonNull FieldType getFieldType() {
        return this.fieldType;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull String getNameFullyQualified() {
        return this.nameFullyQualified;
    }

    public static enum FieldType {
        ACROFIELD,
        XFA_FIELD;

    }
}

