/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.dvbtax.esteuerauszugextractor.dto;

import ch.ech.xmlns.ech_0196._2.QuotationTypeType;
import java.math.BigDecimal;
import java.util.Date;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Stock {
    private @Nullable Date referenceDate;
    private @Nullable Boolean mutation;
    private @Nullable String name;
    private @Nullable QuotationTypeType quotationType;
    private @Nullable BigDecimal quantity;
    private @Nullable String balanceCurrency;
    private @Nullable BigDecimal unitPrice;
    private @Nullable BigDecimal balance;
    private @Nullable BigDecimal reductionCost;
    private @Nullable BigDecimal exchangeRate;
    private @Nullable BigDecimal value;
    private @Nullable Boolean blocked;
    private @Nullable Date blockingTo;

    public @Nullable Date getReferenceDate() {
        return this.referenceDate;
    }

    public @Nullable Boolean isMutation() {
        return this.mutation;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public @Nullable QuotationTypeType getQuotationType() {
        return this.quotationType;
    }

    public @Nullable BigDecimal getQuantity() {
        return this.quantity;
    }

    public @Nullable String getBalanceCurrency() {
        return this.balanceCurrency;
    }

    public @Nullable BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    public @Nullable BigDecimal getBalance() {
        return this.balance;
    }

    public @Nullable BigDecimal getReductionCost() {
        return this.reductionCost;
    }

    public @Nullable BigDecimal getExchangeRate() {
        return this.exchangeRate;
    }

    public @Nullable BigDecimal getValue() {
        return this.value;
    }

    public @Nullable Boolean isBlocked() {
        return this.blocked;
    }

    public @Nullable Date getBlockingTo() {
        return this.blockingTo;
    }

    public static final class Builder {
        private @Nullable Date referenceDate;
        private @Nullable Boolean mutation;
        private @Nullable String name;
        private @Nullable QuotationTypeType quotationType;
        private @Nullable BigDecimal quantity;
        private @Nullable String balanceCurrency;
        private @Nullable BigDecimal unitPrice;
        private @Nullable BigDecimal balance;
        private @Nullable BigDecimal reductionCost;
        private @Nullable BigDecimal exchangeRate;
        private @Nullable BigDecimal value;
        private @Nullable Boolean blocked;
        private @Nullable Date blockingTo;

        private Builder() {
        }

        public static Builder getInstance() {
            return new Builder();
        }

        public @NonNull Builder withReferenceDate(@Nullable Date val) {
            this.referenceDate = val;
            return this;
        }

        public @NonNull Builder withMutation(@Nullable Boolean val) {
            this.mutation = val;
            return this;
        }

        public @NonNull Builder withName(String val) {
            this.name = val;
            return this;
        }

        public @NonNull Builder withQuotationType(QuotationTypeType val) {
            this.quotationType = val;
            return this;
        }

        public @NonNull Builder withQuantity(BigDecimal val) {
            this.quantity = val;
            return this;
        }

        public @NonNull Builder withBalanceCurrency(String val) {
            this.balanceCurrency = val;
            return this;
        }

        public @NonNull Builder withUnitPrice(BigDecimal val) {
            this.unitPrice = val;
            return this;
        }

        public @NonNull Builder withBalance(BigDecimal val) {
            this.balance = val;
            return this;
        }

        public @NonNull Builder withReductionCost(BigDecimal val) {
            this.reductionCost = val;
            return this;
        }

        public @NonNull Builder withExchangeRate(BigDecimal val) {
            this.exchangeRate = val;
            return this;
        }

        public @NonNull Builder withValue(BigDecimal val) {
            this.value = val;
            return this;
        }

        public @NonNull Builder withBlocked(Boolean val) {
            this.blocked = val;
            return this;
        }

        public @NonNull Builder withBlockingTo(@Nullable Date val) {
            this.blockingTo = val;
            return this;
        }

        public @NonNull Stock build() {
            Stock stock = new Stock();
            stock.quantity = this.quantity;
            stock.balanceCurrency = this.balanceCurrency;
            stock.unitPrice = this.unitPrice;
            stock.value = this.value;
            stock.referenceDate = this.referenceDate;
            stock.balance = this.balance;
            stock.name = this.name;
            stock.exchangeRate = this.exchangeRate;
            stock.quotationType = this.quotationType;
            stock.blocked = this.blocked;
            stock.blockingTo = this.blockingTo;
            stock.mutation = this.mutation;
            stock.reductionCost = this.reductionCost;
            return stock;
        }
    }
}

