/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.dvbtax.esteuerauszugextractor.dto;

import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Expense;
import java.math.BigDecimal;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Spesen {
    private @Nullable BigDecimal totalExpenses;
    private @Nullable BigDecimal totalExpensesDeductible;
    private @Nullable BigDecimal totalExpensesDeductibleCanton;
    private @Nullable List<Expense> expenses;

    public @Nullable BigDecimal getTotalExpenses() {
        return this.totalExpenses;
    }

    public @Nullable BigDecimal getTotalExpensesDeductible() {
        return this.totalExpensesDeductible;
    }

    public @Nullable BigDecimal getTotalExpensesDeductibleCanton() {
        return this.totalExpensesDeductibleCanton;
    }

    public @Nullable List<Expense> getExpenses() {
        return this.expenses;
    }

    public static final class Builder {
        private @Nullable BigDecimal totalExpenses;
        private @Nullable BigDecimal totalExpensesDeductible;
        private @Nullable BigDecimal totalExpensesDeductibleCanton;
        private @Nullable List<Expense> expenses;

        private Builder() {
        }

        public static Builder getInstance() {
            return new Builder();
        }

        public @Nullable BigDecimal getTotalExpenses() {
            return this.totalExpenses;
        }

        public @Nullable BigDecimal getTotalExpensesDeductible() {
            return this.totalExpensesDeductible;
        }

        public @Nullable BigDecimal getTotalExpensesDeductibleCanton() {
            return this.totalExpensesDeductibleCanton;
        }

        public @Nullable List<Expense> getExpenses() {
            return this.expenses;
        }

        public @NonNull Builder withTotalExpenses(BigDecimal val) {
            this.totalExpenses = val;
            return this;
        }

        public @NonNull Builder withTotalExpensesDeductible(BigDecimal val) {
            this.totalExpensesDeductible = val;
            return this;
        }

        public @NonNull Builder withTotalExpensesDeductibleCanton(BigDecimal val) {
            this.totalExpensesDeductibleCanton = val;
            return this;
        }

        public @NonNull Builder withExpenses(List<Expense> val) {
            this.expenses = val;
            return this;
        }

        public @NonNull Spesen build() {
            Spesen spesen = new Spesen();
            spesen.totalExpenses = this.totalExpenses;
            spesen.expenses = this.expenses;
            spesen.totalExpensesDeductibleCanton = this.totalExpensesDeductibleCanton;
            spesen.totalExpensesDeductible = this.totalExpensesDeductible;
            return spesen;
        }
    }
}

