/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.dvbtax.esteuerauszugextractor.dto;

import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Payment;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Stock;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.TaxValue;
import ch.ech.xmlns.ech_0196._2.QuotationTypeType;
import ch.ech.xmlns.ech_0196._2.SecurityCategoryType;
import ch.ech.xmlns.ech_0196._2.SecurityTypeType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Security {
    private final @Nullable String depotNumber;
    private final @Nullable BigInteger positionId;
    private final @Nullable Long valorNumber;
    private final @Nullable String isin;
    private final @Nullable String country;
    private final @Nullable String city;
    private final @Nullable String currency;
    private final @Nullable QuotationTypeType quotationType;
    private final @Nullable BigDecimal nominalValue;
    private final @Nullable SecurityCategoryType securityCategory;
    private final @Nullable SecurityTypeType securityType;
    private final @Nullable String securityName;
    private final @Nullable Date issueDate;
    private final @Nullable Date redemptionDate;
    private final @Nullable Date redemptionDateEarly;
    private final @Nullable BigDecimal issuePrice;
    private final @Nullable BigDecimal redemptionPrice;
    private final @Nullable BigDecimal redemptionPriceEarly;
    private final @Nullable BigDecimal interestRate;
    private final @Nullable Boolean variableInterest;
    private final @Nullable Boolean iup;
    private final @Nullable Boolean bfp;
    private final @Nullable BigDecimal stockQuantity;
    private final @Nullable TaxValue taxValue;
    private final @Nullable List<Payment> payments;
    private final @Nullable List<Stock> stocks;

    private Security(Builder builder) {
        this.city = builder.city;
        this.valorNumber = builder.valorNumber;
        this.quotationType = builder.quotationType;
        this.securityName = builder.securityName;
        this.nominalValue = builder.nominalValue;
        this.bfp = builder.bfp;
        this.variableInterest = builder.variableInterest;
        this.redemptionPriceEarly = builder.redemptionPriceEarly;
        this.issuePrice = builder.issuePrice;
        this.iup = builder.iup;
        this.taxValue = builder.taxValue;
        this.currency = builder.currency;
        this.redemptionDate = builder.redemptionDate;
        this.securityType = builder.securityType;
        this.securityCategory = builder.securityCategory;
        this.interestRate = builder.interestRate;
        this.depotNumber = builder.depotNumber;
        this.positionId = builder.positionId;
        this.country = builder.country;
        this.isin = builder.isin;
        this.issueDate = builder.issueDate;
        this.redemptionDateEarly = builder.redemptionDateEarly;
        this.redemptionPrice = builder.redemptionPrice;
        this.stockQuantity = builder.stockQuantity;
        this.payments = builder.payments;
        this.stocks = builder.stocks;
    }

    public @Nullable String getDepotNumber() {
        return this.depotNumber;
    }

    public @Nullable BigInteger getPositionId() {
        return this.positionId;
    }

    public @Nullable Long getValorNumber() {
        return this.valorNumber;
    }

    public @Nullable String getIsin() {
        return this.isin;
    }

    public @Nullable String getCountry() {
        return this.country;
    }

    public @Nullable String getCity() {
        return this.city;
    }

    public @Nullable String getCurrency() {
        return this.currency;
    }

    public @Nullable QuotationTypeType getQuotationType() {
        return this.quotationType;
    }

    public @Nullable BigDecimal getNominalValue() {
        return this.nominalValue;
    }

    public @Nullable SecurityCategoryType getSecurityCategory() {
        return this.securityCategory;
    }

    public @Nullable SecurityTypeType getSecurityType() {
        return this.securityType;
    }

    public @Nullable String getSecurityName() {
        return this.securityName;
    }

    public @Nullable Date getIssueDate() {
        return this.issueDate;
    }

    public @Nullable Date getRedemptionDate() {
        return this.redemptionDate;
    }

    public @Nullable Date getRedemptionDateEarly() {
        return this.redemptionDateEarly;
    }

    public @Nullable BigDecimal getIssuePrice() {
        return this.issuePrice;
    }

    public @Nullable BigDecimal getRedemptionPrice() {
        return this.redemptionPrice;
    }

    public @Nullable BigDecimal getRedemptionPriceEarly() {
        return this.redemptionPriceEarly;
    }

    public @Nullable BigDecimal getInterestRate() {
        return this.interestRate;
    }

    public @Nullable Boolean getVariableInterest() {
        return this.variableInterest;
    }

    public @Nullable Boolean getIup() {
        return this.iup;
    }

    public @Nullable Boolean getBfp() {
        return this.bfp;
    }

    public @Nullable BigDecimal getStockQuantity() {
        return this.stockQuantity;
    }

    public @Nullable TaxValue getTaxValue() {
        return this.taxValue;
    }

    public @Nullable List<Payment> getPayments() {
        return this.payments;
    }

    public @Nullable List<Stock> getStocks() {
        return this.stocks;
    }

    public static final class Builder {
        private @Nullable BigDecimal stockQuantity;
        private @Nullable String depotNumber;
        private @Nullable BigInteger positionId;
        private @Nullable Long valorNumber;
        private @Nullable String isin;
        private @Nullable String country;
        private @Nullable String city;
        private @Nullable String currency;
        private @Nullable QuotationTypeType quotationType;
        private @Nullable BigDecimal nominalValue;
        private @Nullable SecurityCategoryType securityCategory;
        private @Nullable SecurityTypeType securityType;
        private @Nullable String securityName;
        private @Nullable Date issueDate;
        private @Nullable Date redemptionDate;
        private @Nullable Date redemptionDateEarly;
        private @Nullable BigDecimal issuePrice;
        private @Nullable BigDecimal redemptionPrice;
        private @Nullable BigDecimal redemptionPriceEarly;
        private @Nullable BigDecimal interestRate;
        private @Nullable Boolean variableInterest;
        private @Nullable Boolean iup;
        private @Nullable Boolean bfp;
        private @Nullable TaxValue taxValue;
        private @Nullable List<Payment> payments;
        private @Nullable List<Stock> stocks;

        private Builder() {
        }

        public static Builder getInstance() {
            return new Builder();
        }

        public @NonNull Builder withDepotNumber(@Nullable String val) {
            this.depotNumber = val;
            return this;
        }

        public @NonNull Builder withPositionId(@Nullable BigInteger val) {
            this.positionId = val;
            return this;
        }

        public @NonNull Builder withValorNumber(@Nullable Long val) {
            this.valorNumber = val;
            return this;
        }

        public @NonNull Builder withIsin(@Nullable String val) {
            this.isin = val;
            return this;
        }

        public @NonNull Builder withCountry(@Nullable String val) {
            this.country = val;
            return this;
        }

        public @NonNull Builder withCity(@Nullable String val) {
            this.city = val;
            return this;
        }

        public @NonNull Builder withCurrency(@Nullable String val) {
            this.currency = val;
            return this;
        }

        public @NonNull Builder withQuotationType(@Nullable QuotationTypeType val) {
            this.quotationType = val;
            return this;
        }

        public @NonNull Builder withNominalValue(@Nullable BigDecimal val) {
            this.nominalValue = val;
            return this;
        }

        public @NonNull Builder withSecurityCategory(@Nullable SecurityCategoryType val) {
            this.securityCategory = val;
            return this;
        }

        public @NonNull Builder withSecurityType(@Nullable SecurityTypeType val) {
            this.securityType = val;
            return this;
        }

        public @NonNull Builder withSecurityName(@Nullable String val) {
            this.securityName = val;
            return this;
        }

        public @NonNull Builder withIssueDate(@Nullable Date val) {
            this.issueDate = val;
            return this;
        }

        public @NonNull Builder withRedemptionDate(@Nullable Date val) {
            this.redemptionDate = val;
            return this;
        }

        public @NonNull Builder withRedemptionDateEarly(@Nullable Date val) {
            this.redemptionDateEarly = val;
            return this;
        }

        public @NonNull Builder withIssuePrice(@Nullable BigDecimal val) {
            this.issuePrice = val;
            return this;
        }

        public @NonNull Builder withRedemptionPrice(@Nullable BigDecimal val) {
            this.redemptionPrice = val;
            return this;
        }

        public @NonNull Builder withRedemptionPriceEarly(@Nullable BigDecimal val) {
            this.redemptionPriceEarly = val;
            return this;
        }

        public @NonNull Builder withInterestRate(@Nullable BigDecimal val) {
            this.interestRate = val;
            return this;
        }

        public @NonNull Builder withVariableInterest(@Nullable Boolean val) {
            this.variableInterest = val;
            return this;
        }

        public @NonNull Builder withIup(@Nullable Boolean val) {
            this.iup = val;
            return this;
        }

        public @NonNull Builder withBfp(@Nullable Boolean val) {
            this.bfp = val;
            return this;
        }

        public @NonNull Builder withStockQuantity(@Nullable BigDecimal stockQuantity) {
            this.stockQuantity = stockQuantity;
            return this;
        }

        public @NonNull Builder withTaxValue(@Nullable TaxValue val) {
            this.taxValue = val;
            return this;
        }

        public @NonNull Builder withPayments(@Nullable List<Payment> val) {
            this.payments = val;
            return this;
        }

        public @NonNull Builder withStocks(@Nullable List<Stock> val) {
            this.stocks = val;
            return this;
        }

        public @NonNull Security build() {
            Security security = new Security(this);
            return security;
        }
    }
}

