/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.dvbtax.esteuerauszugextractor.dto;

import ch.ech.xmlns.ech_0196._2.QuotationTypeType;
import java.math.BigDecimal;
import java.util.Date;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PurchaseDisposition {
    private @Nullable Date referenceDate;
    private @Nullable QuotationTypeType quotationType;
    private @Nullable BigDecimal quantity;
    private @Nullable BigDecimal bondFloor;
    private @Nullable String balanceCurrency;
    private @Nullable BigDecimal unitPrice;
    private @Nullable BigDecimal balance;
    private @Nullable BigDecimal reductionCost;
    private @Nullable BigDecimal exchangeRate;
    private @Nullable BigDecimal value;

    public @Nullable Date getReferenceDate() {
        return this.referenceDate;
    }

    public @Nullable QuotationTypeType getQuotationType() {
        return this.quotationType;
    }

    public @Nullable BigDecimal getQuantity() {
        return this.quantity;
    }

    public @Nullable BigDecimal getBondFloor() {
        return this.bondFloor;
    }

    public @Nullable String getBalanceCurrency() {
        return this.balanceCurrency;
    }

    public @Nullable BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    public @Nullable BigDecimal getBalance() {
        return this.balance;
    }

    public @Nullable BigDecimal getReductionCost() {
        return this.reductionCost;
    }

    public @Nullable BigDecimal getExchangeRate() {
        return this.exchangeRate;
    }

    public @Nullable BigDecimal getValue() {
        return this.value;
    }

    public static final class PurchaseDispositionBuilder {
        private @Nullable Date referenceDate;
        private @Nullable QuotationTypeType quotationType;
        private @Nullable BigDecimal quantity;
        private @Nullable BigDecimal bondFloor;
        private @Nullable String balanceCurrency;
        private @Nullable BigDecimal unitPrice;
        private @Nullable BigDecimal balance;
        private @Nullable BigDecimal reductionCost;
        private @Nullable BigDecimal exchangeRate;
        private @Nullable BigDecimal value;

        private PurchaseDispositionBuilder() {
        }

        public static PurchaseDispositionBuilder aPurchaseDisposition() {
            return new PurchaseDispositionBuilder();
        }

        public PurchaseDispositionBuilder withReferenceDate(Date referenceDate) {
            this.referenceDate = referenceDate;
            return this;
        }

        public PurchaseDispositionBuilder withQuotationType(QuotationTypeType quotationType) {
            this.quotationType = quotationType;
            return this;
        }

        public PurchaseDispositionBuilder withQuantity(BigDecimal quantity) {
            this.quantity = quantity;
            return this;
        }

        public PurchaseDispositionBuilder withBondFloor(BigDecimal bondFloor) {
            this.bondFloor = bondFloor;
            return this;
        }

        public PurchaseDispositionBuilder withBalanceCurrency(String balanceCurrency) {
            this.balanceCurrency = balanceCurrency;
            return this;
        }

        public PurchaseDispositionBuilder withUnitPrice(BigDecimal unitPrice) {
            this.unitPrice = unitPrice;
            return this;
        }

        public PurchaseDispositionBuilder withBalance(BigDecimal balance) {
            this.balance = balance;
            return this;
        }

        public PurchaseDispositionBuilder withReductionCost(BigDecimal reductionCost) {
            this.reductionCost = reductionCost;
            return this;
        }

        public PurchaseDispositionBuilder withExchangeRate(BigDecimal exchangeRate) {
            this.exchangeRate = exchangeRate;
            return this;
        }

        public PurchaseDispositionBuilder withValue(BigDecimal value) {
            this.value = value;
            return this;
        }

        public PurchaseDisposition build() {
            PurchaseDisposition purchaseDisposition = new PurchaseDisposition();
            purchaseDisposition.quotationType = this.quotationType;
            purchaseDisposition.bondFloor = this.bondFloor;
            purchaseDisposition.unitPrice = this.unitPrice;
            purchaseDisposition.referenceDate = this.referenceDate;
            purchaseDisposition.reductionCost = this.reductionCost;
            purchaseDisposition.balance = this.balance;
            purchaseDisposition.exchangeRate = this.exchangeRate;
            purchaseDisposition.balanceCurrency = this.balanceCurrency;
            purchaseDisposition.value = this.value;
            purchaseDisposition.quantity = this.quantity;
            return purchaseDisposition;
        }
    }
}

