/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.dvbtax.esteuerauszugextractor.dto;

import ch.dvbern.dvbtax.esteuerauszugextractor.dto.BankAccount;
import java.math.BigDecimal;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Konten {
    private @Nullable BigDecimal totalTaxValue;
    private @Nullable BigDecimal totalGrossRevenueA;
    private @Nullable BigDecimal totalGrossRevenueB;
    private @Nullable BigDecimal totalWithHoldingTaxClaim;
    private @Nullable List<BankAccount> bankAccounts;

    public @Nullable BigDecimal getTotalTaxValue() {
        return this.totalTaxValue;
    }

    public @Nullable BigDecimal getTotalGrossRevenueA() {
        return this.totalGrossRevenueA;
    }

    public @Nullable BigDecimal getTotalGrossRevenueB() {
        return this.totalGrossRevenueB;
    }

    public @Nullable BigDecimal getTotalWithHoldingTaxClaim() {
        return this.totalWithHoldingTaxClaim;
    }

    public @Nullable List<BankAccount> getBankAccounts() {
        return this.bankAccounts;
    }

    public static final class Builder {
        private @Nullable BigDecimal totalTaxValue;
        private @Nullable BigDecimal totalGrossRevenueA;
        private @Nullable BigDecimal totalGrossRevenueB;
        private @Nullable BigDecimal totalWithHoldingTaxClaim;
        private @Nullable List<BankAccount> bankAccounts;

        private Builder() {
        }

        public static Builder getInstance() {
            return new Builder();
        }

        public @NonNull Builder withTotalTaxValue(BigDecimal val) {
            this.totalTaxValue = val;
            return this;
        }

        public @NonNull Builder withTotalGrossRevenueA(BigDecimal val) {
            this.totalGrossRevenueA = val;
            return this;
        }

        public @NonNull Builder withTotalGrossRevenueB(BigDecimal val) {
            this.totalGrossRevenueB = val;
            return this;
        }

        public @NonNull Builder withTotalWithHoldingTaxClaim(BigDecimal val) {
            this.totalWithHoldingTaxClaim = val;
            return this;
        }

        public Builder withBankAccounts(List<BankAccount> val) {
            this.bankAccounts = val;
            return this;
        }

        public @NonNull Konten build() {
            Konten konten = new Konten();
            konten.totalWithHoldingTaxClaim = this.totalWithHoldingTaxClaim;
            konten.bankAccounts = this.bankAccounts;
            konten.totalGrossRevenueA = this.totalGrossRevenueA;
            konten.totalGrossRevenueB = this.totalGrossRevenueB;
            konten.totalTaxValue = this.totalTaxValue;
            return konten;
        }
    }
}

