/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.dvbtax.esteuerauszugextractor.dto;

import java.math.BigDecimal;
import java.util.Date;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Expense {
    private @Nullable Date referenceDate;
    private @Nullable String name;
    private @Nullable String iban;
    private @Nullable String bankAccountNumber;
    private @Nullable String depotNumber;
    private @Nullable String amountCurrency;
    private @Nullable BigDecimal amount;
    private @Nullable BigDecimal exchangeRate;
    private @Nullable BigDecimal expenses;
    private @Nullable BigDecimal expensesDeductible;
    private @Nullable BigDecimal expensesDeductibleCanton;

    public @Nullable Date getReferenceDate() {
        return this.referenceDate;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public @Nullable String getIban() {
        return this.iban;
    }

    public @Nullable String getBankAccountNumber() {
        return this.bankAccountNumber;
    }

    public @Nullable String getDepotNumber() {
        return this.depotNumber;
    }

    public @Nullable String getAmountCurrency() {
        return this.amountCurrency;
    }

    public @Nullable BigDecimal getAmount() {
        return this.amount;
    }

    public @Nullable BigDecimal getExchangeRate() {
        return this.exchangeRate;
    }

    public @Nullable BigDecimal getExpenses() {
        return this.expenses;
    }

    public @Nullable BigDecimal getExpensesDeductible() {
        return this.expensesDeductible;
    }

    public @Nullable BigDecimal getExpensesDeductibleCanton() {
        return this.expensesDeductibleCanton;
    }

    public static final class Builder {
        private @Nullable Date referenceDate;
        private @Nullable String name;
        private @Nullable String iban;
        private @Nullable String bankAccountNumber;
        private @Nullable String depotNumber;
        private @Nullable String amountCurrency;
        private @Nullable BigDecimal amount;
        private @Nullable BigDecimal exchangeRate;
        private @Nullable BigDecimal expenses;
        private @Nullable BigDecimal expensesDeductible;
        private @Nullable BigDecimal expensesDeductibleCanton;

        private Builder() {
        }

        public static Builder getInstance() {
            return new Builder();
        }

        public @NonNull Builder withReferenceDate(@Nullable Date val) {
            this.referenceDate = val;
            return this;
        }

        public @NonNull Builder withName(String val) {
            this.name = val;
            return this;
        }

        public @NonNull Builder withIban(String val) {
            this.iban = val;
            return this;
        }

        public @NonNull Builder withBankAccountNumber(String val) {
            this.bankAccountNumber = val;
            return this;
        }

        public @NonNull Builder withDepotNumber(String val) {
            this.depotNumber = val;
            return this;
        }

        public @NonNull Builder withAmountCurrency(String val) {
            this.amountCurrency = val;
            return this;
        }

        public @NonNull Builder withAmount(BigDecimal val) {
            this.amount = val;
            return this;
        }

        public @NonNull Builder withExchangeRate(BigDecimal val) {
            this.exchangeRate = val;
            return this;
        }

        public @NonNull Builder withExpenses(BigDecimal val) {
            this.expenses = val;
            return this;
        }

        public @NonNull Builder withExpensesDeductible(BigDecimal val) {
            this.expensesDeductible = val;
            return this;
        }

        public @NonNull Builder withExpensesDeductibleCanton(BigDecimal val) {
            this.expensesDeductibleCanton = val;
            return this;
        }

        public @NonNull Expense build() {
            Expense expense = new Expense();
            expense.depotNumber = this.depotNumber;
            expense.bankAccountNumber = this.bankAccountNumber;
            expense.expenses = this.expenses;
            expense.iban = this.iban;
            expense.exchangeRate = this.exchangeRate;
            expense.amountCurrency = this.amountCurrency;
            expense.expensesDeductible = this.expensesDeductible;
            expense.expensesDeductibleCanton = this.expensesDeductibleCanton;
            expense.referenceDate = this.referenceDate;
            expense.name = this.name;
            expense.amount = this.amount;
            return expense;
        }
    }
}

