/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.vision.pdf417;

import com.java4less.vision.RImage;
import com.java4less.vision.VisionException;
import com.java4less.vision.barcode.pdf417.DecodeCWException;
import com.java4less.vision.barcode.pdf417.InvalidCWException;
import com.java4less.vision.barcode.pdf417.PDF417Area;
import com.java4less.vision.barcode.pdf417.PDF417CWDecoder;
import com.java4less.vision.barcode.pdf417.PDF417Decoder;
import com.java4less.vision.barcode.pdf417.ScanCodeword;
import com.java4less.vision.barcode.pdf417.ScanLine;
import com.java4less.vision.barcode.pdf417.rs.PDF417RS;
import com.java4less.vision.pdf417.PDF417Data;
import com.java4less.vision.recognition.Barcode1DFinder;
import com.java4less.vision.recognition.Barcode1DObject;
import com.java4less.vision.recognition.BarsReader;
import com.java4less.vision.recognition.ImageObject;
import com.java4less.vision.recognition.Line;
import com.java4less.vision.recognition.LineWalker;
import com.java4less.vision.recognition.PAVectorizer;
import com.java4less.vision.recognition.Point;
import com.java4less.vision.recognition.VectorizedImage;
import com.java4less.vision.util.DebugFrame;
import com.java4less.vision.util.Histogram;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;

public class PDF417Reader {
    public boolean applyContrast = System.getProperty("com.java4less.vision.contrast", "0").equals("1");
    ScanCodeword[][] cwArray = new ScanCodeword[90][90];
    ScanCodeword cwArrayRowsDiv = new ScanCodeword();
    ScanCodeword cwArrayRowsMod = new ScanCodeword();
    ScanCodeword cwArrayCols = new ScanCodeword();
    ScanCodeword ecLevel = new ScanCodeword();
    double barcodeWidthCorrection = 0.0;
    private int[] STOP_CHAR = new int[]{7, 1, 1, 3, 1, 1, 1, 2, 1};
    private int[] START_CHAR = new int[]{8, 1, 1, 1, 1, 1, 1};
    private int[] STOP_CHAR_REVERSE = new int[]{1, 2, 1, 1, 1, 3, 1, 1, 7};
    private int[] START_CHAR_REVERSE = new int[]{1, 1, 1, 1, 1, 1, 8};
    Hashtable corruptScanLines = new Hashtable();
    ArrayList[] colPositions = new ArrayList[31];
    private boolean debug = System.getProperty("com.java4less.vision.debug", "0").equals("1");
    public boolean verbose = false;
    public boolean isBWImage = false;

    public PDF417Data[] read(RImage inputImage) throws VisionException {
        Vector<PDF417Data> result = new Vector<PDF417Data>();
        RImage bwImage = null;
        if (this.applyContrast) {
            inputImage.initializePixels();
            Histogram hist = new Histogram(inputImage);
            hist.stretch();
            inputImage.memoryToImage();
        }
        bwImage = !this.isBWImage ? inputImage.toBackWhite() : inputImage;
        inputImage = null;
        bwImage.initializePixels();
        PAVectorizer vect = new PAVectorizer();
        VectorizedImage vi = vect.vectorize(bwImage);
        if (this.debug) {
            Line[] lines = vi.getLinesAsArray();
            DebugFrame.defaultInstance.show(bwImage, lines, "Vectorized ");
        }
        Vector candidateAreas = this.findPDF417(bwImage, vi);
        for (int i = 0; i < candidateAreas.size(); ++i) {
            PDF417Data data = this.scanArea(bwImage, (PDF417Area)candidateAreas.elementAt(i));
            if (data == null) continue;
            result.add(data);
        }
        PDF417Data[] a = new PDF417Data[result.size()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = (PDF417Data)result.elementAt(i);
        }
        return a;
    }

    private PDF417Data scanArea(RImage image, PDF417Area area) {
        int r;
        int i;
        this.corruptScanLines.clear();
        this.cwArray = new ScanCodeword[90][90];
        this.barcodeWidthCorrection = 0.0;
        for (i = 0; i < this.cwArray.length; ++i) {
            for (int j = 0; j < this.cwArray[i].length; ++j) {
                this.cwArray[i][j] = new ScanCodeword();
            }
        }
        this.ecLevel = new ScanCodeword();
        this.cwArrayCols = new ScanCodeword();
        this.cwArrayRowsDiv = new ScanCodeword();
        this.cwArrayRowsMod = new ScanCodeword();
        for (i = 0; i < this.colPositions.length; ++i) {
            this.colPositions[i] = new ArrayList();
        }
        LineWalker walker1 = new LineWalker(area.startBar);
        int debugCounter = 0;
        Point p1 = walker1.getNextPoint();
        while (p1 != null) {
            ++debugCounter;
            Point p2 = area.startBar.getPerp(p1, 50.0).getIntersect(area.endBar);
            Line scanLine = new Line(p1, p2);
            if (this.debug) {
                System.out.println("Scan line number " + debugCounter);
            }
            this.processScanLine(image, scanLine, area.barcodeWidthCorrection);
            p1 = walker1.getNextPoint();
        }
        int rows = this.cwArrayRowsDiv.getValue() * 3 + this.cwArrayRowsMod.getValue() + 1;
        int cols = this.cwArrayCols.getValue();
        if (rows < 3 || cols <= 0) {
            if (this.verbose || this.debug) {
                System.out.println("Too few rows/cols");
            }
            return null;
        }
        if (rows > 90 || cols > 90) {
            if (this.verbose || this.debug) {
                System.out.println("Too many rows/cols");
            }
            return null;
        }
        int ecLen = (int)Math.pow(2.0, this.ecLevel.getValue() + 1);
        if (ecLen > rows * cols) {
            if (this.verbose || this.debug) {
                System.out.println("EcLen too long");
            }
            return null;
        }
        double barcodeWidth = area.endBar.getDistance(new Point(area.startBar.x1, area.startBar.y1));
        double expectedColumnWidth = barcodeWidth / (double)(cols + 4);
        int[] mediansColPos = new int[this.colPositions.length];
        for (int i2 = 0; i2 < this.colPositions.length; ++i2) {
            Collections.sort(this.colPositions[i2]);
            if (this.colPositions[i2].size() <= 0) continue;
            mediansColPos[i2] = (Integer)this.colPositions[i2].get(this.colPositions[i2].size() / 2);
        }
        boolean debugcw = this.verbose || this.debug;
        for (r = 0; r < rows; ++r) {
            if (debugcw) {
                System.out.println("");
            }
            String s = "";
            for (int col = 0; col < cols; ++col) {
                if (!debugcw) continue;
                s = s + " " + this.cwArray[r][col];
            }
            System.out.print(s);
        }
        for (r = 0; r < rows; ++r) {
            block13: for (int col = 0; col < cols; ++col) {
                Vector lines;
                if (this.cwArray[r][col].getValue() != -1 || (lines = (Vector)this.corruptScanLines.get(new Integer(r))) == null) continue;
                for (int l = 0; l < lines.size(); ++l) {
                    int[] E;
                    int cluster;
                    ScanLine line = (ScanLine)lines.elementAt(l);
                    int colPositionMedian = mediansColPos[col];
                    int positionIndex = 0;
                    for (int i3 = 0; i3 < line.counter; ++i3) {
                        if (Math.abs(line.positions[positionIndex] - colPositionMedian) <= Math.abs(line.positions[i3] - colPositionMedian) || line.typeOfEdge[i3] != ScanLine.W2B) continue;
                        positionIndex = i3;
                    }
                    if (!((double)Math.abs(line.positions[positionIndex] - colPositionMedian) < expectedColumnWidth / 2.0) || (cluster = this.getCluster(E = this.getSymbol(line.eDistances, line.positions, positionIndex))) != 3 && cluster != 6 && cluster != 0) continue;
                    int codeword = this.getCodeword(E, cluster /= 3);
                    this.setArrayCW(codeword, r, col, true);
                    if (!this.verbose && !this.debug) continue block13;
                    System.out.println("Correcting codeword (" + r + "," + col + ") = " + codeword);
                    continue block13;
                }
            }
        }
        int missing = 0;
        for (int r2 = 0; r2 < rows; ++r2) {
            for (int col = 0; col < cols; ++col) {
                if (this.cwArray[r2][col].getValue() != -1) continue;
                ++missing;
            }
        }
        if (missing > ecLen / 2) {
            if (this.verbose || this.debug) {
                System.out.println("Too many unknown codewords " + missing + ">" + ecLen / 2);
            }
            return null;
        }
        int[] cws = new int[rows * cols];
        int i4 = 0;
        if (debugcw) {
            System.out.println("\nNew codewords ");
        }
        for (int r3 = 0; r3 < rows; ++r3) {
            if (debugcw) {
                System.out.println("");
            }
            String s = "";
            for (int col = 0; col < cols; ++col) {
                cws[i4++] = this.cwArray[r3][col].getValue() != -1 ? this.cwArray[r3][col].getValue() : 0;
                if (!debugcw) continue;
                s = s + " " + this.cwArray[r3][col];
            }
            System.out.print(s);
        }
        PDF417RS rs = new PDF417RS();
        int rsResult = 0;
        try {
            rsResult = rs.decode(cws, ecLen);
        }
        catch (Exception e) {
            rsResult = -1;
            e.printStackTrace();
        }
        if (this.verbose || this.debug) {
            System.out.println("\nRS result=" + rsResult);
        }
        int[] correctedCWS = new int[cws.length - ecLen];
        for (i4 = 0; i4 < correctedCWS.length; ++i4) {
            correctedCWS[i4] = cws[i4];
        }
        if (debugcw) {
            System.out.print("\nCorrected CW=");
            for (i4 = 0; i4 < correctedCWS.length; ++i4) {
                System.out.println(" " + correctedCWS[i4]);
            }
            System.out.print("\n");
        }
        PDF417CWDecoder decoder = new PDF417CWDecoder();
        try {
            int[] result = decoder.decode(correctedCWS);
            PDF417Data data = new PDF417Data(result, (int)area.startBar.x1, (int)area.startBar.y1, decoder.macroPDFFields, rsResult, ecLen / 2);
            return data;
        }
        catch (InvalidCWException e) {
            if (this.debug) {
                e.printStackTrace();
            }
            return null;
        }
        catch (DecodeCWException e) {
            if (this.debug) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private void setArrayCW(int cw, int row, int col, boolean force) {
        if (!force) {
            this.cwArray[row][col].addValue(cw);
        } else {
            this.cwArray[row][col].setValue(cw);
        }
    }

    private void processScanLine(RImage image, Line line, double barcodeWidthCorrection) {
        ScanLine scanLine = new ScanLine(image, line, barcodeWidthCorrection);
        if (scanLine.counter < 32) {
            return;
        }
        boolean symbolOK = true;
        int pointer = 8;
        int[] E = this.getSymbol(scanLine.eDistances, scanLine.positions, pointer);
        pointer += 8;
        int cluster = this.getCluster(E);
        if (cluster == 3) {
            cluster = 1;
        } else if (cluster == 6) {
            cluster = 2;
        } else if (cluster != 0) {
            return;
        }
        int codeword = this.getCodeword(E, cluster);
        int startRow = (int)Math.floor(codeword / 30);
        int startRowBase = startRow *= 3;
        int currentCluster = cluster;
        int currentRowOffset = cluster;
        if (codeword != -1) {
            if (cluster == 2) {
                this.cwArrayCols.addValue(codeword % 30 + 1);
            }
            if (cluster == 1) {
                this.cwArrayRowsMod.addValue(codeword % 30 % 3);
                this.ecLevel.addValue((int)Math.floor(codeword % 30 / 3));
            }
            if (cluster == 0) {
                this.cwArrayRowsDiv.addValue(codeword % 30);
            }
        }
        startRow += cluster;
        int[] cws = new int[90];
        int[] clusters = new int[90];
        int cwsp = 0;
        int col = 0;
        boolean pdfRowCrossing = false;
        boolean someError = false;
        while (pointer + 8 <= scanLine.counter) {
            symbolOK = true;
            int currentPosition = scanLine.positions[pointer];
            E = this.getSymbol(scanLine.eDistances, scanLine.positions, pointer);
            pointer += 8;
            cluster = this.getCluster(E);
            if (cluster == 3) {
                cluster = 1;
            } else if (cluster == 6) {
                cluster = 2;
            } else if (cluster != 0) {
                symbolOK = false;
                someError = true;
                break;
            }
            if (symbolOK) {
                codeword = this.getCodeword(E, cluster);
                clusters[cwsp] = cluster;
                cws[cwsp++] = codeword;
                this.colPositions[col].add(new Integer(currentPosition));
                int r = -1;
                if (currentCluster == cluster) {
                    r = startRowBase + currentRowOffset;
                } else {
                    pdfRowCrossing = true;
                    int step = 0;
                    if (currentCluster == 0 && cluster == 1) {
                        step = 1;
                    }
                    if (currentCluster == 1 && cluster == 2) {
                        step = 1;
                    }
                    if (currentCluster == 2 && cluster == 0) {
                        step = 1;
                    }
                    if (currentCluster == 0 && cluster == 2) {
                        step = -1;
                    }
                    if (currentCluster == 1 && cluster == 0) {
                        step = -1;
                    }
                    if (currentCluster == 2 && cluster == 1) {
                        step = -1;
                    }
                    if (step != 0) {
                        currentCluster = cluster;
                        r = startRowBase + (currentRowOffset += step);
                    }
                }
                if (r >= 90 || col >= 90) {
                    return;
                }
                if (r >= 0 && col >= 0) {
                    this.setArrayCW(codeword, r, col, false);
                }
            } else {
                if (this.debug) {
                    System.out.println("Wrong symbol");
                }
                clusters[cwsp] = -1;
                cws[cwsp++] = -1;
            }
            ++col;
        }
        if (!pdfRowCrossing && someError) {
            Vector<ScanLine> v = (Vector<ScanLine>)this.corruptScanLines.get(new Integer(startRowBase + currentRowOffset));
            if (v == null) {
                v = new Vector<ScanLine>();
                this.corruptScanLines.put(new Integer(startRowBase + currentRowOffset), v);
            }
            v.add(scanLine);
        }
        if (--cwsp >= 3) {
            codeword = cws[cwsp];
            cluster = clusters[cwsp];
            int endRow = (int)Math.floor(codeword / 30);
            endRow += cluster;
            if (cluster == 0 && codeword != -1) {
                this.cwArrayCols.addValue(codeword % 30 + 1);
            }
        }
    }

    private int getCodeword(int[] Es, int cluster) {
        String s = "" + Es[0] + Es[1] + Es[2] + Es[3] + Es[4] + Es[5];
        if (s.length() > 6) {
            return -1;
        }
        for (int i = 0; i < PDF417Decoder.E_DISTANCES[cluster].length; ++i) {
            if (!PDF417Decoder.E_DISTANCES[cluster][i].equals(s)) continue;
            return i;
        }
        return -1;
    }

    private int getCluster(int[] Es) {
        return (Es[0] - Es[1] + Es[4] - Es[5] + 9) % 9;
    }

    private int[] getSymbol(int[] eDistances, int[] positions, int pointer) {
        int p = positions[pointer + 8] - positions[pointer];
        int[] es = new int[6];
        for (int i = 0; i < 6; ++i) {
            es[i] = eDistances[pointer + i];
        }
        int[] Es = new int[6];
        for (int i = 0; i < 6; ++i) {
            for (int j = 1; j <= 8; ++j) {
                if (!(((double)j + 0.5) * (double)p / 17.0 <= (double)es[i]) || !((double)es[i] < ((double)j + 1.5) * (double)p / 17.0)) continue;
                Es[i] = j + 1;
            }
        }
        return Es;
    }

    private void processCW(int[] widths) {
        int e1 = widths[0] + widths[1];
        int e2 = widths[1] + widths[2];
        int e3 = widths[2] + widths[3];
        int e4 = widths[3] + widths[4];
        int e5 = widths[4] + widths[5];
        int e6 = widths[4] + widths[5];
        int p = widths[0] + widths[1] + widths[2] + widths[3] + widths[4] + widths[5];
        int[] es = new int[]{e1, e2, e3, e4, e4, e5, e6};
        int[] Es = new int[6];
        for (int i = 0; i <= 6; ++i) {
            for (int j = 1; j <= 8; ++j) {
                if (!(((double)j + 0.5) * (double)p / 17.0 <= (double)es[i]) || !((double)es[i] < ((double)j + 1.5) * (double)p / 17.0)) continue;
                Es[i] = j + 1;
            }
        }
        int cluster = (Es[0] - Es[1] + Es[4] - Es[5] + 9) % 9;
    }

    public Vector findPDF417(RImage image, VectorizedImage vi) throws VisionException {
        Barcode1DObject bc;
        int i;
        Vector<PDF417Area> candidateAreas = new Vector<PDF417Area>();
        Barcode1DFinder finder = new Barcode1DFinder();
        finder.minbars = 4;
        finder.supportBrokenBars = false;
        BarsReader barReader = new BarsReader();
        Vector barcodes = finder.findBarcodes(vi, image);
        for (int i2 = 0; i2 < barcodes.size(); ++i2) {
            Barcode1DObject bc2 = (Barcode1DObject)barcodes.elementAt(i2);
            double[] widths = barReader.convertBarsToWidths(BarsReader.ALG_AREAS, image, bc2);
            bc2.setWidths(widths);
            bc2.setFlag(0);
        }
        int FLAG_START = 1;
        int FLAG_STOP = 2;
        int FLAG_START_REV = 4;
        int FLAG_STOP_REV = 8;
        for (i = 0; i < barcodes.size(); ++i) {
            bc = (Barcode1DObject)barcodes.elementAt(i);
            double[] widths = bc.getWidths();
            if (this.debug) {
                System.out.println("Candidate bars width: ");
                for (int j = 0; j < widths.length; ++j) {
                    System.out.print(" " + widths[j]);
                }
                System.out.println("");
            }
            if (this.debug) {
                try {
                    DebugFrame.defaultInstance.show(image, bc.getBarsArray(), "Candidate " + i);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            if (this.isMatchPattern(bc, widths, this.START_CHAR, this.START_CHAR.length - 1, 0)) {
                bc.setFlag(bc.getFlag() | FLAG_START);
            }
            if (this.isMatchPattern(bc, widths, this.STOP_CHAR_REVERSE, this.STOP_CHAR_REVERSE.length, 0)) {
                bc.setFlag(bc.getFlag() | FLAG_STOP_REV);
            }
            if (this.isMatchPattern(bc, widths, this.STOP_CHAR, this.STOP_CHAR.length, widths.length - 9)) {
                bc.setFlag(bc.getFlag() | FLAG_STOP);
            }
            if (!this.isMatchPattern(bc, widths, this.START_CHAR_REVERSE, this.START_CHAR_REVERSE.length, widths.length - 7)) continue;
            bc.setFlag(bc.getFlag() | FLAG_START_REV);
        }
        for (i = 0; i < barcodes.size(); ++i) {
            bc = (Barcode1DObject)barcodes.elementAt(i);
            if ((bc.getFlag() & FLAG_START) == 0) continue;
            for (int j = 0; j < barcodes.size(); ++j) {
                Barcode1DObject bc2 = (Barcode1DObject)barcodes.elementAt(j);
                if ((bc2.getFlag() & FLAG_STOP) == 0) continue;
                Line firstBar = ((ImageObject)bc.bars.get(0)).getPA();
                Line lastBar = ((ImageObject)bc2.bars.get(bc2.bars.size() - 1)).getPA();
                if (!this.compareAngles(firstBar.getAngle(), lastBar.getAngle(), 5.0) || !firstBar.isCenterAligned(lastBar, 0.4)) continue;
                Line l1 = new Line(new Point(firstBar.x1, firstBar.y1), new Point(lastBar.x1, lastBar.y1));
                Line l2 = new Line(new Point(firstBar.x1, firstBar.y1), new Point(lastBar.x2, lastBar.y2));
                if (l1.getLength() > l2.getLength()) {
                    lastBar = new Line(new Point(lastBar.x2, lastBar.y2), new Point(lastBar.x1, lastBar.y1));
                }
                candidateAreas.add(new PDF417Area(firstBar, lastBar, false, (bc.pdf417BarcodeWidthCorrection + bc2.pdf417BarcodeWidthCorrection) / 2.0));
                if (!this.debug) continue;
                DebugFrame.defaultInstance.show(image, new Line[]{firstBar, lastBar}, "PDF417 Area " + i);
            }
        }
        for (i = 0; i < barcodes.size(); ++i) {
            bc = (Barcode1DObject)barcodes.elementAt(i);
            if ((bc.getFlag() & FLAG_STOP_REV) == 0) continue;
            for (int j = 0; j < barcodes.size(); ++j) {
                Barcode1DObject bc2 = (Barcode1DObject)barcodes.elementAt(j);
                if ((bc2.getFlag() & FLAG_START_REV) == 0) continue;
                Line lastBar = ((ImageObject)bc.bars.get(0)).getPA();
                Line firstBar = ((ImageObject)bc2.bars.get(bc2.bars.size() - 1)).getPA();
                if (!this.compareAngles(firstBar.getAngle(), lastBar.getAngle(), 5.0) || !firstBar.isCenterAligned(lastBar, 0.5)) continue;
                candidateAreas.add(new PDF417Area(firstBar, lastBar, true, (bc.pdf417BarcodeWidthCorrection + bc2.pdf417BarcodeWidthCorrection) / 2.0));
                if (!this.debug) continue;
                DebugFrame.defaultInstance.show(image, new Line[]{firstBar, lastBar}, "PDF417 Area " + i);
            }
        }
        return candidateAreas;
    }

    private boolean compareAngles(double a1, double a2, double diff) {
        if (Math.abs(a1 - a2) < diff) {
            return true;
        }
        double tmp = a1 + 180.0;
        if (tmp > 360.0) {
            tmp -= 360.0;
        }
        if (Math.abs(tmp - a2) < diff) {
            return true;
        }
        tmp = a2 + 180.0;
        if (tmp > 360.0) {
            tmp -= 360.0;
        }
        return Math.abs(a1 - tmp) < diff;
    }

    private boolean isMatchPattern(Barcode1DObject bc, double[] widths, int[] pattern, int patternLen, int baseIndex) {
        int i;
        if (baseIndex < 0) {
            return false;
        }
        if (baseIndex + patternLen > widths.length) {
            return false;
        }
        double wunit = 0.0;
        double bunit = 0.0;
        int wcounter = 0;
        int bcounter = 0;
        boolean bar = true;
        for (i = 0; i < patternLen; ++i) {
            if (pattern[i] == 1) {
                if (!bar) {
                    ++wcounter;
                    wunit += widths[baseIndex + i];
                } else {
                    ++bcounter;
                    bunit += widths[baseIndex + i];
                }
            }
            bar = !bar;
        }
        wunit /= (double)wcounter;
        bunit /= (double)bcounter;
        bar = true;
        for (i = 0; i < patternLen; ++i) {
            double unit = wunit;
            if (bar) {
                unit = bunit;
            }
            double barw = widths[baseIndex + i] / unit;
            double min = (double)pattern[i] - (double)pattern[i] * 0.3;
            double max = (double)pattern[i] + (double)pattern[i] * 0.3;
            if ((i == 0 || i == patternLen - 1) && pattern[i] == 3 ? barw < min : !(barw > min) || !(barw < max)) {
                return false;
            }
            bar = !bar;
        }
        bc.pdf417BarcodeWidthCorrection = (wunit - bunit) / 2.0;
        return true;
    }
}

