/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.vision.barcode.pdf417;

import com.java4less.vision.RImage;
import com.java4less.vision.recognition.Line;
import com.java4less.vision.recognition.LineWalker;
import com.java4less.vision.recognition.Point;

public class ScanLine {
    Line line;
    RImage image;
    public int[] eDistances;
    public int[] positions;
    public int[] typeOfEdge;
    public int counter;
    public static int B2W = 0;
    public static int W2B = 1;
    public double barcodeWidthCorrection = 0.0;

    public ScanLine(RImage im, Line scanLine, double correction) {
        this.image = im;
        this.line = scanLine;
        this.barcodeWidthCorrection = correction;
        this.init();
    }

    private void init() {
        this.eDistances = new int[(int)(this.line.getLength() / 2.0)];
        this.positions = new int[this.eDistances.length];
        this.typeOfEdge = new int[this.eDistances.length];
        int pointerCounter = 0;
        int lastColor = RImage.FOREGROUND;
        int lastBWEdge = 0;
        int lastWBEdge = 0;
        LineWalker walker = new LineWalker(this.line);
        Point p = walker.getNextPoint();
        while (p != null) {
            ++pointerCounter;
            int color = this.image.getPixel(p);
            if (lastColor == RImage.FOREGROUND && color == RImage.BACKGROUND) {
                if (this.counter > 0) {
                    this.eDistances[this.counter] = pointerCounter - lastBWEdge;
                    this.typeOfEdge[this.counter] = B2W;
                    this.positions[this.counter++] = lastBWEdge;
                }
                lastBWEdge = pointerCounter;
            }
            if (lastColor == RImage.BACKGROUND && color == RImage.FOREGROUND) {
                this.eDistances[this.counter] = pointerCounter - lastWBEdge;
                this.typeOfEdge[this.counter] = W2B;
                this.positions[this.counter++] = lastWBEdge;
                lastWBEdge = pointerCounter;
            }
            lastColor = color;
            p = walker.getNextPoint();
        }
    }
}

