/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.vision.barcode.pdf417;

import com.java4less.vision.barcode.pdf417.DecodeCWException;
import com.java4less.vision.barcode.pdf417.InvalidCWException;
import com.java4less.vision.pdf417.PDF417Data;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;

public class PDF417CWDecoder {
    public static int LATCH_TO_TEXT = 900;
    public static int LATCH_TO_BYTE = 901;
    public static int LATCH_TO_NUMERIC = 902;
    public static int SHIFT_TO_BYTE = 913;
    public static int READER_INITIALISATION = 921;
    public static int MACRO_TERMINATOR = 922;
    public static int MACRO_SEPARATOR = 923;
    public static int LATCH_TO_BYTE6 = 924;
    public static int ECI_USER = 925;
    public static int ECI_GENERAL = 926;
    public static int ECI_CODEPAGE = 927;
    public static int MACRO_START = 928;
    public static int[] NUMERIC_MODE_TERMINATORS = new int[]{LATCH_TO_TEXT, LATCH_TO_BYTE, LATCH_TO_NUMERIC, LATCH_TO_BYTE6, MACRO_TERMINATOR, MACRO_SEPARATOR, MACRO_START};
    public static int[] BYTE_MODE_TERMINATORS = NUMERIC_MODE_TERMINATORS;
    public static int[] TEXT_MODE_TERMINATORS = NUMERIC_MODE_TERMINATORS;
    protected String[] setMixed = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "&", "\r", "\t", ",", ":", "#", "-", ".", "$", "/", "+", "%", "*", "=", "^", "PL", " ", "LL", "AL", "PS"};
    protected String[] setPunctuation = new String[]{";", "<", ">", "@", "[", "\\", "]", "_", "\u2018", "~", "!", "\r", "\t", ",", ":", "\n", "-", ".", "$", "/", "\"", "|", "*", "(", ")", "?", "{", "}", "'", "AL"};
    protected String[] setUpperAlpha = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", " ", "LL", "ML", "PS"};
    protected String[] setLowerAlpha = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", " ", "AS", "ML", "PS"};
    private static final int PDF_BINARY = 0;
    private static final int PDF_TEXT = 1;
    private static final int PDF_NUMERIC = 2;
    private static final int SUBMODE_UPPER = 0;
    private static final int SUBMODE_LOWER = 1;
    private static final int SUBMODE_MIXED = 2;
    private static final int SUBMODE_PUNCTUATION = 3;
    public Object[] macroPDFFields = new Object[9];

    private boolean inArray(int[] a, int val) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != val) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        PDF417CWDecoder decoder = new PDF417CWDecoder();
        int[] cw = new int[]{61, 1, 63, 121, 211, 117, 1, 228, 33, 216, 117, 117, 627, 237, 627, 118, 32, 92, 92, 123, 843, 607, 607, 813, 830, 814, 835, 830, 829, 835, 830, 817, 830, 31, 211, 211, 830, 110, 230, 118, 87, 607, 603, 230, 857, 813, 607, 543, 859, 893, 894, 830, 230, 213, 607, 830, 913, 65, 1};
        try {
            int[] result = decoder.decode(cw);
            byte[] bytes = new byte[result.length];
            System.out.println("result = ");
            for (int i = 0; i < result.length; ++i) {
                System.out.print(", " + result[i]);
                bytes[i] = (byte)result[i];
            }
            System.out.println("");
            System.out.println("Str= " + new String(bytes, "US-ASCII"));
            int[] cw2 = new int[]{10, 901, 82, 399, 748, 339, 234, 49, 50, 51, 738, 816};
            result = decoder.decode(cw2);
            bytes = new byte[result.length];
            System.out.println("result = ");
            for (int i = 0; i < result.length; ++i) {
                System.out.print(", " + result[i]);
                bytes[i] = (byte)result[i];
            }
            System.out.println("");
            int[] cw3 = new int[]{22, 902, 868, 766, 590, 147, 477, 220, 528, 74, 552, 194, 800, 556, 438, 134, 634, 15, 369, 753, 194, 900, 786, 591};
            result = decoder.decode(cw3);
            bytes = new byte[result.length];
            System.out.println("result = ");
            for (int i = 0; i < result.length; ++i) {
                System.out.print(", " + result[i]);
                bytes[i] = (byte)result[i];
            }
            System.out.println("");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int[] decode(int[] cws) throws InvalidCWException, DecodeCWException {
        int[] pointer = new int[]{1};
        int outp = 0;
        int[] output = new int[cws.length * 44 / 15];
        boolean mode = true;
        int codewordsCount = cws[0];
        int macroPDFField = -1;
        while (pointer[0] < codewordsCount && pointer[0] < cws.length) {
            int cw = cws[pointer[0]];
            if (cw == LATCH_TO_NUMERIC) {
                pointer[0] = pointer[0] + 1;
                int[] tmp = this.decodeNumeric(cws, pointer, codewordsCount);
                System.arraycopy(tmp, 0, output, outp, tmp.length);
                outp += tmp.length;
                continue;
            }
            if (cw == LATCH_TO_BYTE || cw == LATCH_TO_BYTE6) {
                int[] tmp = this.decodeBinary(cws, pointer, codewordsCount);
                System.arraycopy(tmp, 0, output, outp, tmp.length);
                outp += tmp.length;
                continue;
            }
            if (cw == READER_INITIALISATION) {
                pointer[0] = pointer[0] + 1;
                continue;
            }
            if (cw == MACRO_START) {
                pointer[0] = pointer[0] + 1;
                macroPDFField = 0;
                int[] tmp = new int[2];
                int n = pointer[0];
                pointer[0] = n + 1;
                tmp[0] = cws[n];
                int n2 = pointer[0];
                pointer[0] = n2 + 1;
                tmp[1] = cws[n2];
                int[] tmpp = new int[]{0};
                this.macroPDFFields[PDF417Data.MACROPDF_SEGMENT] = this.fromBase900(tmp, tmpp, 2);
                String fileID = "";
                while (pointer[0] < codewordsCount && pointer[0] < cws.length && (cw = cws[pointer[0]]) != MACRO_SEPARATOR && cw != MACRO_TERMINATOR) {
                    if (fileID.length() > 0) {
                        fileID = fileID + "-";
                    }
                    fileID = fileID + cw;
                    pointer[0] = pointer[0] + 1;
                }
                this.macroPDFFields[PDF417Data.MACROPDF_FILEID] = fileID;
                continue;
            }
            if (cw == MACRO_SEPARATOR) {
                Object tmp;
                pointer[0] = pointer[0] + 1;
                int descriptor = cws[pointer[0]];
                pointer[0] = pointer[0] + 1;
                int field = descriptor + 2;
                if (field == PDF417Data.MACROPDF_SEGMENT_COUNT || field == PDF417Data.MACROPDF_FILESIZE || field == PDF417Data.MACROPDF_CHECKSUM || field == PDF417Data.MACROPDF_TIMESTAMP) {
                    this.macroPDFFields[field] = tmp = this.fromBase900(cws, pointer, codewordsCount);
                    continue;
                }
                tmp = this.decodeText(cws, pointer, codewordsCount);
                byte[] bytes = new byte[((Object)tmp).length];
                for (int h = 0; h < ((Object)tmp).length; ++h) {
                    bytes[h] = (byte)tmp[h];
                }
                try {
                    this.macroPDFFields[field] = new String(bytes, "US-ASCII");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (cw == MACRO_TERMINATOR) {
                pointer[0] = pointer[0] + 1;
                continue;
            }
            if (cw != LATCH_TO_TEXT && pointer[0] != 1) continue;
            if (cw == LATCH_TO_TEXT) {
                pointer[0] = pointer[0] + 1;
            }
            int[] tmp = this.decodeText(cws, pointer, codewordsCount);
            System.arraycopy(tmp, 0, output, outp, tmp.length);
            outp += tmp.length;
        }
        int[] result = new int[outp];
        System.arraycopy(output, 0, result, 0, outp);
        return result;
    }

    private int[] decodeText(int[] cw, int[] pointer, int totalCws) throws InvalidCWException, DecodeCWException {
        byte[] tmp;
        int i;
        int p = pointer[0];
        int submode = 0;
        int previousSubmode = 0;
        boolean shift = false;
        String output = "";
        while (p < cw.length && p < totalCws) {
            int cword = cw[p];
            if (this.inArray(TEXT_MODE_TERMINATORS, cword)) break;
            if (cword == SHIFT_TO_BYTE) {
                if (++p >= cw.length || p >= totalCws) break;
                output = output + (char)cw[p];
                ++p;
                continue;
            }
            if (cword >= 900) {
                throw new InvalidCWException("Codeword " + cword + " found in Text mode");
            }
            int[] chars = new int[]{(int)Math.floor(cword / 30), cword % 30};
            for (i = 0; i < 2; ++i) {
                String charac;
                String[] set = this.setUpperAlpha;
                if (submode == 1) {
                    set = this.setLowerAlpha;
                }
                if (submode == 2) {
                    set = this.setMixed;
                }
                if (submode == 3) {
                    set = this.setPunctuation;
                }
                if ((charac = set[chars[i]]).length() == 2) {
                    if (charac.equals("LL")) {
                        submode = 1;
                    }
                    if (charac.equals("AL")) {
                        submode = 0;
                    }
                    if (charac.equals("AS")) {
                        shift = true;
                        previousSubmode = submode;
                        submode = 0;
                    }
                    if (charac.equals("ML")) {
                        submode = 2;
                    }
                    if (charac.equals("PS")) {
                        if (i == 1 && p + 1 < cw.length && cw[p + 1] == 913) break;
                        shift = true;
                        previousSubmode = submode;
                        submode = 3;
                    }
                    if (!charac.equals("PL")) continue;
                    submode = 3;
                    continue;
                }
                output = output + charac;
                if (!shift) continue;
                shift = false;
                submode = previousSubmode;
            }
            ++p;
        }
        pointer[0] = p;
        try {
            tmp = output.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new DecodeCWException(e.getMessage());
        }
        int[] itmp = new int[tmp.length];
        for (i = 0; i < tmp.length; ++i) {
            itmp[i] = tmp[i];
        }
        return itmp;
    }

    private int[] decodeBinary(int[] cw, int[] pointer, int totalCws) throws InvalidCWException {
        int p = pointer[0];
        int[] output = new int[cw.length * 2];
        int oCounter = 0;
        int binaryLatch = cw[pointer[0]];
        ++p;
        int[] bytes = new int[5];
        int cwCounter = 0;
        while (p < cw.length && p < totalCws) {
            int cword = cw[p];
            if (this.inArray(BYTE_MODE_TERMINATORS, cword)) break;
            bytes[cwCounter] = cword;
            if (++cwCounter == 5) {
                int h;
                boolean haveMoreCW = true;
                if (p + 1 < cw.length && p + 1 < totalCws) {
                    int nextcword = cw[p + 1];
                    if (this.inArray(BYTE_MODE_TERMINATORS, nextcword)) {
                        ++p;
                        haveMoreCW = false;
                    }
                } else {
                    ++p;
                    haveMoreCW = false;
                }
                if (!haveMoreCW && binaryLatch == LATCH_TO_BYTE) break;
                BigInteger codeval = BigInteger.valueOf(bytes[0]);
                System.out.println("");
                for (h = 1; h < 5; ++h) {
                    codeval = codeval.multiply(BigInteger.valueOf(900L));
                    codeval = codeval.add(BigInteger.valueOf(bytes[h]));
                }
                for (h = 1; h <= 6; ++h) {
                    output[oCounter + (6 - h)] = codeval.mod(BigInteger.valueOf(256L)).intValue();
                    codeval = codeval.divide(BigInteger.valueOf(256L));
                }
                oCounter += 6;
                cwCounter = 0;
                if (!haveMoreCW && binaryLatch == LATCH_TO_BYTE6) break;
            }
            ++p;
        }
        if (cwCounter == 0 && binaryLatch != LATCH_TO_BYTE6) {
            throw new InvalidCWException("Latch should be LATCH_TO_BYTE6");
        }
        if (cwCounter != 0 && binaryLatch != LATCH_TO_BYTE) {
            throw new InvalidCWException("Latch should be LATCH_TO_BYTE");
        }
        if (cwCounter > 0 && binaryLatch == LATCH_TO_BYTE) {
            for (int i = 0; i < cwCounter; ++i) {
                output[oCounter++] = bytes[i];
            }
        }
        int[] result = new int[oCounter];
        for (int h = 0; h < oCounter; ++h) {
            result[h] = output[h];
        }
        pointer[0] = p;
        return result;
    }

    private String fromBase900(int[] cws, int[] pointer, int cwsCounter) {
        int cw;
        int[] values = new int[100];
        int counter = 0;
        while (pointer[0] < cwsCounter && (cw = cws[pointer[0]]) != MACRO_SEPARATOR && cw != MACRO_TERMINATOR) {
            values[counter++] = cw;
            pointer[0] = pointer[0] + 1;
        }
        BigInteger v = BigInteger.valueOf(0L);
        for (int i = 0; i < counter; ++i) {
            v = v.multiply(BigInteger.valueOf(900L));
            v = v.add(BigInteger.valueOf(values[i]));
        }
        String s = v.toString();
        return s.substring(1);
    }

    private int[] decodeNumeric(int[] cw, int[] pointer, int totalCws) throws InvalidCWException, DecodeCWException {
        byte[] tmp;
        int p;
        String output = "";
        int cwCounter = 0;
        BigInteger codeval = BigInteger.valueOf(0L);
        for (p = pointer[0]; p < cw.length && p < totalCws; ++p) {
            int cword = cw[p];
            if (this.inArray(NUMERIC_MODE_TERMINATORS, cword)) break;
            codeval = codeval.multiply(BigInteger.valueOf(900L));
            codeval = codeval.add(BigInteger.valueOf(cword));
            if (++cwCounter != 15) continue;
            System.out.println(codeval.toString(10));
            output = output + this.decodeDigits(codeval);
            cwCounter = 0;
            codeval = BigInteger.valueOf(0L);
        }
        if (cwCounter > 0) {
            output = output + this.decodeDigits(codeval);
        }
        pointer[0] = p;
        try {
            tmp = output.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new DecodeCWException(e.getMessage());
        }
        int[] itmp = new int[tmp.length];
        for (int i = 0; i < tmp.length; ++i) {
            itmp[i] = tmp[i];
        }
        return itmp;
    }

    private String decodeDigits(BigInteger codeval) {
        String s = "";
        while (codeval.compareTo(BigInteger.valueOf(0L)) > 0) {
            int i = codeval.mod(BigInteger.valueOf(10L)).intValue();
            s = "" + i + s;
            codeval = codeval.divide(BigInteger.valueOf(10L));
        }
        return s.substring(1, s.length());
    }
}

