/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rbarcode;

import com.java4less.rbarcode.BarCode;
import com.java4less.rbarcode.BarCode2D;
import com.java4less.rdatamatrix.RDataMatrix;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RBarCodeServlet
extends HttpServlet {
    private boolean debug = false;
    public BarCode BC = null;

    public void init() throws ServletException {
    }

    private BarCode getBC(HttpServletRequest request) {
        this.BCinit(request.getParameter("CODE_TYPE"));
        if (request != null) {
            if (request.getParameter("DEBUG") != null && request.getParameter("DEBUG").toUpperCase().compareTo("ON") == 0) {
                this.debug = true;
            }
            Enumeration ps = request.getParameterNames();
            while (ps.hasMoreElements()) {
                String name = (String)ps.nextElement();
                this.setParameter(name, request.getParameter(name));
                if (!this.debug) continue;
                System.out.println("PARAM: " + name + "=" + request.getParameter(name));
            }
        }
        return this.BC;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String encode = "jpeg";
        String outputmode = "image";
        if (request != null) {
            if (request.getParameter("FORMAT") != null) {
                encode = request.getParameter("FORMAT").toLowerCase();
            }
            if (request.getParameter("OUTPUTMODE") != null) {
                outputmode = request.getParameter("OUTPUTMODE").toLowerCase();
            }
            if (encode.toLowerCase().compareTo("gif") != 0 && encode.toLowerCase().compareTo("png") != 0) {
                encode = "jpeg";
            }
        }
        if (outputmode.equals("file")) {
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment; filename=\"barcode" + System.currentTimeMillis() + "." + encode + "\"");
        } else {
            response.setContentType("image/" + encode);
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", 0L);
        }
        ServletOutputStream outb = response.getOutputStream();
        try {
            int w = 400;
            int h = 200;
            if (request != null) {
                if (request.getParameter("WIDTH") != null) {
                    w = new Integer(request.getParameter("WIDTH"));
                }
                if (request.getParameter("HEIGHT") != null) {
                    h = new Integer(request.getParameter("HEIGHT"));
                }
            }
            BufferedImage BarImage = new BufferedImage(w, h, 1);
            Graphics2D BarGraphics = BarImage.createGraphics();
            BarCode cb = this.getBC(request);
            if (this.debug) {
                System.out.println("Size: " + w + " " + h);
            }
            cb.setSize(w, h);
            cb.paint(BarGraphics);
            if (encode.toLowerCase().compareTo("gif") == 0) {
                Class<?> enClass = Class.forName("Acme.JPM.Encoders.GifEncoder");
                Class[] constructorParams = new Class[]{Class.forName("java.awt.Image"), Class.forName("java.io.OutputStream")};
                Object[] constructorObj = new Object[]{BarImage, outb};
                Object encoder = enClass.getConstructor(constructorParams).newInstance(constructorObj);
                Class[] encodeParams = new Class[]{};
                Object[] encodeObj = new Object[]{};
                enClass.getMethod("encode", encodeParams).invoke(encoder, encodeObj);
            } else if (encode.toLowerCase().compareTo("png") == 0) {
                Class<?> enClass = Class.forName("com.bigfoot.bugar.image.PNGEncoder");
                Class[] constructorParams = new Class[]{Class.forName("java.awt.Image"), Class.forName("java.io.OutputStream")};
                Object[] constructorObj = new Object[]{BarImage, outb};
                Object encoder = enClass.getConstructor(constructorParams).newInstance(constructorObj);
                Class[] encodeParams = new Class[]{};
                Object[] encodeObj = new Object[]{};
                enClass.getMethod("encodeImage", encodeParams).invoke(encoder, encodeObj);
            } else {
                JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)outb);
                encoder.encode(BarImage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            this.doGet(request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void BCinit(String type) {
        System.out.println("Type: " + type);
        if (type != null) {
            if (type.compareTo("PDF417") == 0) {
                System.out.println("PDF417");
                this.BC = new BarCode2D();
                return;
            }
            if (type.compareTo("DATAMATRIX") == 0) {
                this.BC = new RDataMatrix();
                return;
            }
        }
        this.BC = new BarCode();
    }

    public void setParameter(String p, String v) {
        if (v == null) {
            return;
        }
        if (p.compareTo("CODE_TYPE") == 0) {
            if (v.compareTo("BAR39") == 0) {
                this.BC.barType = 0;
            }
            if (v.compareTo("BAR39EXT") == 0) {
                this.BC.barType = 1;
            }
            if (v.compareTo("CODE93") == 0) {
                this.BC.barType = 9;
            }
            if (v.compareTo("CODE11") == 0) {
                this.BC.barType = 3;
            }
            if (v.compareTo("CODABAR") == 0) {
                this.BC.barType = 4;
            }
            if (v.compareTo("CODE93EXT") == 0) {
                this.BC.barType = 14;
            }
            if (v.compareTo("CODE128") == 0) {
                this.BC.barType = 13;
            }
            if (v.compareTo("MSI") == 0) {
                this.BC.barType = 5;
            }
            if (v.compareTo("IND25") == 0) {
                this.BC.barType = 7;
            }
            if (v.compareTo("MAT25") == 0) {
                this.BC.barType = 8;
            }
            if (v.compareTo("INTERLEAVED25") == 0) {
                this.BC.barType = 2;
            }
            if (v.compareTo("EAN13") == 0) {
                this.BC.barType = 10;
            }
            if (v.compareTo("EAN8") == 0) {
                this.BC.barType = 11;
            }
            if (v.compareTo("EAN128") == 0) {
                this.BC.barType = 16;
            }
            if (v.compareTo("UPCA") == 0) {
                this.BC.barType = 6;
            }
            if (v.compareTo("UPCE") == 0) {
                this.BC.barType = 12;
            }
            if (v.compareTo("POSTNET") == 0) {
                this.BC.barType = 15;
            }
            if (v.compareTo("PDF417") == 0) {
                this.BC.barType = 30;
            }
            if (v.compareTo("DATAMATRIX") == 0) {
                this.BC.barType = 31;
            }
        }
        if (p.compareTo("N") == 0) {
            this.BC.N = new Double(v);
        }
        if (p.compareTo("PROCESS_TILDE") == 0) {
            boolean bl = this.BC.processTilde = v.toUpperCase().compareTo("Y") == 0;
        }
        if (p.compareTo("SUPPLEMENT_CODE") == 0) {
            this.BC.supplement = v;
        }
        if (p.compareTo("CODETEXT") == 0) {
            this.BC.codeText = v;
        }
        if (p.compareTo("SUPPLEMENT_SEPARATION") == 0) {
            this.BC.supSeparationCM = new Double(v);
        }
        if (p.compareTo("SUPPLEMENT_HEIGHT") == 0) {
            this.BC.supHeight = new Double(v);
        }
        if (p.compareTo("SUPPLEMENT") == 0) {
            this.BC.UPCEANSupplement2 = false;
            this.BC.UPCEANSupplement5 = false;
            if (v.compareTo("2") == 0) {
                this.BC.UPCEANSupplement2 = true;
            }
            if (v.compareTo("5") == 0) {
                this.BC.UPCEANSupplement5 = true;
            }
        }
        if (p.compareTo("MSICHECKSUM") == 0) {
            if (v.compareTo("10") == 0) {
                this.BC.MSIChecksum = 0;
            }
            if (v.compareTo("11") == 0) {
                this.BC.MSIChecksum = 1;
            }
            if (v.compareTo("10_10") == 0) {
                this.BC.MSIChecksum = 3;
            }
            if (v.compareTo("11_10") == 0) {
                this.BC.MSIChecksum = 2;
            }
        }
        if (p.compareTo("ROTATE") == 0) {
            this.BC.rotate = (int)new Double(v).doubleValue();
        }
        if (p.compareTo("POSTNET_TALL") == 0) {
            this.BC.postnetHeightTallBar = (int)new Double(v).doubleValue();
        }
        if (p.compareTo("POSTNET_SHORT") == 0) {
            this.BC.postnetHeightShortBar = (int)new Double(v).doubleValue();
        }
        if (p.compareTo("X") == 0) {
            this.BC.X = new Double(v);
        }
        if (p.compareTo("I") == 0) {
            this.BC.I = new Double(v);
        }
        if (p.compareTo("LEFT_MARGIN") == 0) {
            this.BC.leftMarginCM = new Double(v);
        }
        if (p.compareTo("TOP_MARGIN") == 0) {
            this.BC.topMarginCM = new Double(v);
        }
        if (p.compareTo("BAR_COLOR") == 0) {
            this.BC.barColor = this.convertColor(v);
        }
        if (p.compareTo("FONT_COLOR") == 0) {
            this.BC.fontColor = this.convertColor(v);
        }
        if (p.compareTo("BACK_COLOR") == 0) {
            this.BC.backColor = this.convertColor(v);
        }
        if (p.compareTo("RESOLUTION") == 0) {
            this.BC.resolution = new Integer(v);
        }
        if (p.compareTo("TEXT_ON_TOP") == 0) {
            boolean bl = this.BC.textOnTop = v.compareTo("Y") == 0;
        }
        if (p.compareTo("GUARDBARS") == 0) {
            boolean bl = this.BC.guardBars = v.compareTo("Y") == 0;
        }
        if (p.compareTo("UPCE_SYSTEM") == 0) {
            this.BC.UPCESytem = new String(v + "1").charAt(0);
        }
        if (p.compareTo("CODABAR_START") == 0) {
            this.BC.CODABARStartChar = new String(v + "A").charAt(0);
        }
        if (p.compareTo("CODABAR_STOP") == 0) {
            this.BC.CODABARStopChar = new String(v + "A").charAt(0);
        }
        if (p.compareTo("TEXT_FONT") == 0) {
            this.BC.textFont = this.convertFont(v);
        }
        if (p.compareTo("H") == 0) {
            this.BC.H = new Double(v);
        }
        if (p.compareTo("BARCODE") == 0) {
            this.BC.code = v;
        }
        if (p.compareTo("CHECK_CHAR") == 0) {
            boolean bl = this.BC.checkCharacter = v.compareTo("Y") == 0;
        }
        if (p.compareTo("CODE128_SET") == 0) {
            this.BC.Code128Set = new String(v + "B").charAt(0);
        }
        if (p.compareTo("BAR_HEIGHT") == 0) {
            this.BC.barHeightCM = new Double(v);
        }
        if (this.BC instanceof BarCode2D) {
            if (p.compareTo("PDF_ROWS") == 0) {
                ((BarCode2D)this.BC).PDFRows = new Integer(v);
            }
            if (p.compareTo("PDF_MAXROWS") == 0) {
                ((BarCode2D)this.BC).PDFMaxRows = new Integer(v);
            }
            if (p.compareTo("PDF_COLUMNS") == 0) {
                ((BarCode2D)this.BC).PDFColumns = new Integer(v);
            }
            if (p.compareTo("PDF_ECLEVEL") == 0) {
                ((BarCode2D)this.BC).PDFECLevel = new Integer(v);
            }
            if (p.compareTo("PDF_COMPACTION") == 0) {
                if (v.compareTo("BINARY") == 0) {
                    BarCode2D cfr_ignored_0 = (BarCode2D)this.BC;
                    ((BarCode2D)this.BC).PDFMode = 0;
                }
                if (v.compareTo("NUMERIC") == 0) {
                    BarCode2D cfr_ignored_1 = (BarCode2D)this.BC;
                    ((BarCode2D)this.BC).PDFMode = 2;
                }
                if (v.compareTo("TEXT") == 0) {
                    BarCode2D cfr_ignored_2 = (BarCode2D)this.BC;
                    ((BarCode2D)this.BC).PDFMode = 1;
                }
            }
        }
        if (this.BC instanceof RDataMatrix) {
            if (p.compareTo("DM_DOT_PIXELS") == 0) {
                ((RDataMatrix)this.BC).dotPixels = new Integer(v);
            }
            if (p.compareTo("DM_TILDE") == 0) {
                boolean bl = ((RDataMatrix)this.BC).processTilde = v.toUpperCase().compareTo("Y") == 0;
            }
            if (p.compareTo("DM_MARGIN_PIXELS") == 0) {
                ((RDataMatrix)this.BC).margin = new Integer(v);
            }
            if (p.compareTo("DM_ENCODING") == 0) {
                if (v.toUpperCase().compareTo("ASCII") == 0) {
                    ((RDataMatrix)this.BC).encoding = RDataMatrix.E_ASCII;
                }
                if (v.toUpperCase().compareTo("C40") == 0) {
                    ((RDataMatrix)this.BC).encoding = RDataMatrix.E_C40;
                }
                if (v.toUpperCase().compareTo("TEXT") == 0) {
                    ((RDataMatrix)this.BC).encoding = RDataMatrix.E_TEXT;
                }
                if (v.toUpperCase().compareTo("BASE256") == 0) {
                    ((RDataMatrix)this.BC).encoding = RDataMatrix.E_BASE256;
                }
                if (v.toUpperCase().compareTo("AUTO") == 0) {
                    ((RDataMatrix)this.BC).encoding = RDataMatrix.E_AUTO;
                }
            }
            if (p.compareTo("DM_FORMAT") == 0) {
                ((RDataMatrix)this.BC).preferredFormat = -1;
                if (v.toUpperCase().compareTo("C10X10") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 0;
                }
                if (v.toUpperCase().compareTo("C12X12") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 1;
                }
                if (v.toUpperCase().compareTo("C14X14") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 2;
                }
                if (v.toUpperCase().compareTo("C16X16") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 3;
                }
                if (v.toUpperCase().compareTo("C18X18") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 4;
                }
                if (v.toUpperCase().compareTo("C20X20") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 5;
                }
                if (v.toUpperCase().compareTo("C22X22") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 6;
                }
                if (v.toUpperCase().compareTo("C24X24") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 7;
                }
                if (v.toUpperCase().compareTo("C26X26") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 8;
                }
                if (v.toUpperCase().compareTo("C32X32") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 9;
                }
                if (v.toUpperCase().compareTo("C36X36") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 10;
                }
                if (v.toUpperCase().compareTo("C40X40") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 11;
                }
                if (v.toUpperCase().compareTo("C44X44") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 12;
                }
                if (v.toUpperCase().compareTo("C48X48") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 13;
                }
                if (v.toUpperCase().compareTo("C52X52") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 14;
                }
                if (v.toUpperCase().compareTo("C64X64") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 15;
                }
                if (v.toUpperCase().compareTo("C72X72") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 16;
                }
                if (v.toUpperCase().compareTo("C80X80") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 17;
                }
                if (v.toUpperCase().compareTo("C96X96") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 19;
                }
                if (v.toUpperCase().compareTo("C104X104") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 20;
                }
                if (v.toUpperCase().compareTo("C88X88") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 18;
                }
                if (v.toUpperCase().compareTo("C120X120") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 21;
                }
                if (v.toUpperCase().compareTo("C132X132") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 22;
                }
                if (v.toUpperCase().compareTo("C144X144") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 23;
                }
                if (v.toUpperCase().compareTo("C8X18") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 24;
                }
                if (v.toUpperCase().compareTo("C8X32") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 25;
                }
                if (v.toUpperCase().compareTo("C12X26") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 26;
                }
                if (v.toUpperCase().compareTo("C12X36") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 27;
                }
                if (v.toUpperCase().compareTo("C16X36") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 28;
                }
                if (v.toUpperCase().compareTo("C16X48") == 0) {
                    ((RDataMatrix)this.BC).preferredFormat = 29;
                }
            }
        }
    }

    public Color convertColor(String c) {
        if (c.compareTo("NULL") == 0) {
            return null;
        }
        if (c.compareTo("RED") == 0) {
            return Color.red;
        }
        if (c.compareTo("BLACK") == 0) {
            return Color.black;
        }
        if (c.compareTo("BLUE") == 0) {
            return Color.blue;
        }
        if (c.compareTo("CYAN") == 0) {
            return Color.cyan;
        }
        if (c.compareTo("DARKGRAY") == 0) {
            return Color.darkGray;
        }
        if (c.compareTo("GRAY") == 0) {
            return Color.gray;
        }
        if (c.compareTo("GREEN") == 0) {
            return Color.green;
        }
        if (c.compareTo("LIGHTGRAY") == 0) {
            return Color.lightGray;
        }
        if (c.compareTo("MAGENTA") == 0) {
            return Color.magenta;
        }
        if (c.compareTo("ORANGE") == 0) {
            return Color.orange;
        }
        if (c.compareTo("PINK") == 0) {
            return Color.pink;
        }
        if (c.compareTo("WHITE") == 0) {
            return Color.white;
        }
        if (c.compareTo("YELLOW") == 0) {
            return Color.yellow;
        }
        try {
            return Color.decode(c);
        }
        catch (Exception e) {
            return Color.black;
        }
    }

    public Font convertFont(String f) {
        String[] items = this.convertList(f);
        if (items == null) {
            return null;
        }
        if (items.length < 3) {
            return null;
        }
        int s = 0;
        if (items[1].compareTo("BOLD") == 0) {
            s = 1;
        }
        if (items[1].compareTo("ITALIC") == 0) {
            s = 2;
        }
        try {
            return new Font(items[0], s, new Integer(items[2]));
        }
        catch (Exception e) {
            return null;
        }
    }

    private String[] convertList(String items) {
        String[] itema = new String[500];
        int itemCount = 0;
        int p = items.indexOf("|");
        while (p >= 0) {
            itema[itemCount++] = items.substring(0, p);
            items = items.substring(p + 1, items.length());
            p = items.indexOf("|");
        }
        if (items.compareTo("") != 0) {
            itema[itemCount++] = items;
        }
        if (itemCount == 0) {
            return null;
        }
        String[] result = new String[itemCount];
        for (int i = 0; i < itemCount; ++i) {
            result[i] = itema[i];
        }
        return result;
    }
}

