/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rbarcode;

import com.java4less.rbarcode.BarCode;
import com.java4less.rbarcode.common.IBarcodeGenerator;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Properties;

public class BarCodeFacade
implements IBarcodeGenerator {
    private BarCode bc;

    public BarCode getBarcode() {
        return this.bc;
    }

    public Image createBarcodeImage(String type, String value, String set, String processTilde, String text, int rotate, int barHeight, int X, int N, String barColor, String fontColor, String backColor, String textFont, int leftMargin, int topMargin, boolean generateCheckCharacter, Properties properties) {
        this.createBarcode(type, value, set, processTilde, text, rotate, barHeight, X, N, barColor, fontColor, backColor, textFont, leftMargin, topMargin, generateCheckCharacter, properties);
        return this.createImage();
    }

    public Image createBarcodeImage(String type, String value, String set, String processTilde, String text, int rotate, int barHeight, int X, int N, String barColor, String fontColor, String backColor, String textFont, int leftMargin, int topMargin, Properties properties) {
        this.createBarcode(type, value, set, processTilde, text, rotate, barHeight, X, N, barColor, fontColor, backColor, textFont, leftMargin, topMargin, properties);
        return this.createImage();
    }

    public void createBarcode(String type, String value, String set, String processTilde, String text, int rotate, int barHeight, int X, int N, String barColor, String fontColor, String backColor, String textFont, int leftMargin, int topMargin, Properties properties) {
        this.createBarcode(type, value, set, processTilde, text, rotate, barHeight, X, N, barColor, fontColor, backColor, textFont, leftMargin, topMargin, true, properties);
    }

    public void createBarcode(String type, String value, String set, String processTilde, String text, int rotate, int barHeight, int X, int N, String barColor, String fontColor, String backColor, String textFont, int leftMargin, int topMargin, boolean checksum, Properties properties) {
        this.bc = new BarCode();
        if (type.compareTo("BAR39") == 0) {
            this.bc.barType = 0;
        }
        if (type.compareTo("BAR39EXT") == 0) {
            this.bc.barType = 1;
        }
        if (type.compareTo("CODE93") == 0) {
            this.bc.barType = 9;
        }
        if (type.compareTo("CODE11") == 0) {
            this.bc.barType = 3;
        }
        if (type.compareTo("CODABAR") == 0) {
            this.bc.barType = 4;
        }
        if (type.compareTo("CODE93EXT") == 0) {
            this.bc.barType = 14;
        }
        if (type.compareTo("CODE128") == 0) {
            this.bc.barType = 13;
            if (set.equalsIgnoreCase("A")) {
                this.bc.Code128Set = (char)65;
            }
            if (set.equalsIgnoreCase("B")) {
                this.bc.Code128Set = (char)66;
            }
            if (set.equalsIgnoreCase("C")) {
                this.bc.Code128Set = (char)67;
            }
        }
        if (type.compareTo("MSI") == 0) {
            this.bc.barType = 5;
        }
        if (type.compareTo("IND25") == 0) {
            this.bc.barType = 7;
        }
        if (type.compareTo("MAT25") == 0) {
            this.bc.barType = 8;
        }
        if (type.compareTo("INTERLEAVED25") == 0) {
            this.bc.barType = 2;
        }
        if (type.compareTo("EAN13") == 0) {
            this.bc.barType = 10;
        }
        if (type.compareTo("EAN8") == 0) {
            this.bc.barType = 11;
        }
        if (type.compareTo("EAN128") == 0) {
            this.bc.barType = 16;
        }
        if (type.compareTo("UPCA") == 0) {
            this.bc.barType = 6;
        }
        if (type.compareTo("UPCE") == 0) {
            this.bc.barType = 12;
        }
        if (type.compareTo("POSTNET") == 0) {
            this.bc.barType = 15;
        }
        this.bc.code = value;
        if (this.bc.barType == 10) {
            String sup;
            int p = value.indexOf("-");
            if (p > 0) {
                this.bc.code = value.substring(0, p);
            }
            if ((sup = value.substring(p + 1)).length() == 2) {
                this.bc.supplement = sup;
                this.bc.UPCEANSupplement2 = true;
            }
            if (sup.length() == 5) {
                this.bc.supplement = sup;
                this.bc.UPCEANSupplement5 = true;
            }
        }
        this.bc.checkCharacter = checksum;
        if (text != null) {
            this.bc.codeText = text;
        }
        this.bc.processTilde = processTilde.equalsIgnoreCase("true");
        this.bc.X = X;
        if (N >= 1) {
            this.bc.N = N;
        }
        this.bc.barHeightCM = barHeight >= 1 ? (double)barHeight : 20.0;
        this.bc.topMarginCM = topMargin;
        this.bc.leftMarginCM = leftMargin;
        this.bc.resolution = 1;
        if (rotate >= 0) {
            this.bc.rotate = rotate;
        }
        if (fontColor != null && fontColor.length() > 0) {
            this.bc.fontColor = this.convertColor(fontColor);
        }
        if (backColor != null && backColor.length() > 0) {
            this.bc.backColor = this.convertColor(backColor);
        }
        if (barColor != null && barColor.length() > 0) {
            this.bc.barColor = this.convertColor(barColor);
        }
        if (textFont != null && textFont.length() > 0) {
            this.bc.textFont = this.convertFont(textFont);
        }
    }

    public Image createImage() {
        BufferedImage barImage = new BufferedImage(500, 500, 1);
        Graphics2D barGraphics = barImage.createGraphics();
        this.bc.setSize(500, 500);
        this.bc.paint(barGraphics);
        int w = (int)(this.bc.getPaintedArea().getWidth() + this.bc.leftMarginCM);
        int h = (int)this.bc.getPaintedArea().getHeight();
        barImage = new BufferedImage(w, h, 1);
        this.bc.setSize(w, h);
        barGraphics = barImage.createGraphics();
        this.bc.paint(barGraphics);
        return barImage;
    }

    private String[] convertList(String items) {
        String[] itema = new String[500];
        int itemCount = 0;
        int p = items.indexOf("|");
        while (p >= 0) {
            itema[itemCount++] = items.substring(0, p);
            items = items.substring(p + 1, items.length());
            p = items.indexOf("|");
        }
        if (items.compareTo("") != 0) {
            itema[itemCount++] = items;
        }
        if (itemCount == 0) {
            return null;
        }
        String[] result = new String[itemCount];
        for (int i = 0; i < itemCount; ++i) {
            result[i] = itema[i];
        }
        return result;
    }

    private Font convertFont(String f) {
        String[] items = this.convertList(f);
        if (items == null) {
            return null;
        }
        if (items.length < 3) {
            return null;
        }
        int s = 0;
        if (items[1].compareTo("BOLD") == 0) {
            s = 1;
        }
        if (items[1].compareTo("ITALIC") == 0) {
            s = 2;
        }
        try {
            return new Font(items[0], s, new Integer(items[2]));
        }
        catch (Exception e) {
            return null;
        }
    }

    private Color convertColor(String c) {
        if (c.compareTo("NULL") == 0) {
            return null;
        }
        if (c.compareTo("RED") == 0) {
            return Color.red;
        }
        if (c.compareTo("BLACK") == 0) {
            return Color.black;
        }
        if (c.compareTo("BLUE") == 0) {
            return Color.blue;
        }
        if (c.compareTo("CYAN") == 0) {
            return Color.cyan;
        }
        if (c.compareTo("DARKGRAY") == 0) {
            return Color.darkGray;
        }
        if (c.compareTo("GRAY") == 0) {
            return Color.gray;
        }
        if (c.compareTo("GREEN") == 0) {
            return Color.green;
        }
        if (c.compareTo("LIGHTGRAY") == 0) {
            return Color.lightGray;
        }
        if (c.compareTo("MAGENTA") == 0) {
            return Color.magenta;
        }
        if (c.compareTo("ORANGE") == 0) {
            return Color.orange;
        }
        if (c.compareTo("PINK") == 0) {
            return Color.pink;
        }
        if (c.compareTo("WHITE") == 0) {
            return Color.white;
        }
        if (c.compareTo("YELLOW") == 0) {
            return Color.yellow;
        }
        try {
            return Color.decode(c);
        }
        catch (Exception e) {
            return Color.black;
        }
    }

    public void createBarcode(Properties properties) {
        this.createBarcodeFromProperties(properties);
    }

    protected void createBarcodeFromProperties(Properties properties) {
        String topMargin;
        String leftMargin;
        String barHeight;
        String X;
        String N;
        String text;
        String check;
        String processTilde;
        String set;
        String type;
        String code = properties.getProperty("value".toUpperCase());
        if (code == null) {
            code = "";
        }
        if ((type = properties.getProperty("type".toUpperCase())) == null) {
            type = "";
        }
        if ((set = properties.getProperty("set".toUpperCase())) == null) {
            set = "";
        }
        if ((processTilde = properties.getProperty("processTilde".toUpperCase())) == null) {
            processTilde = "false";
        }
        if ((check = properties.getProperty("checksum".toUpperCase())) == null) {
            check = "true";
        }
        if (check.length() == 0) {
            check = "true";
        }
        if ((text = properties.getProperty("text".toUpperCase())) == null) {
            text = "";
        }
        String barColor = properties.getProperty("barColor".toUpperCase());
        String fontColor = properties.getProperty("fontColor".toUpperCase());
        String backColor = properties.getProperty("backColor".toUpperCase());
        String textFont = properties.getProperty("textFont".toUpperCase());
        String rotate = properties.getProperty("rotate".toUpperCase());
        if (rotate == null) {
            rotate = "0";
        }
        if ((N = properties.getProperty("N".toUpperCase())) == null) {
            N = "2";
        }
        if ((X = properties.getProperty("X".toUpperCase())) == null) {
            X = "1";
        }
        if ((barHeight = properties.getProperty("barHeight".toUpperCase())) == null) {
            barHeight = "20";
        }
        if ((leftMargin = properties.getProperty("leftMargin".toUpperCase())) == null) {
            leftMargin = "20";
        }
        if ((topMargin = properties.getProperty("topMargin".toUpperCase())) == null) {
            topMargin = "20";
        }
        Properties additionalProperties = (Properties)properties.get("additionalProperties");
        this.createBarcode(type, code, set, processTilde, text, Integer.parseInt(rotate), Integer.parseInt(barHeight), Integer.parseInt(X), Integer.parseInt(N), barColor, fontColor, backColor, textFont, Integer.parseInt(leftMargin), Integer.parseInt(topMargin), check.equalsIgnoreCase("true"), properties);
    }

    public void paintBarcode(Graphics g) {
        this.bc.paint(g);
    }
}

